/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.layout;

import com.greymerk.roguelike.dungeon.layout.ExitType;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_5699;

public class Exit
implements Comparable<Exit> {
    private ExitType type;
    private Coord origin;
    private Cardinal dir;
    public static Codec<Exit> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("type").forGetter(exit -> exit.type.name()), (App)Coord.CODEC.fieldOf("origin").forGetter(exit -> exit.origin), (App)class_5699.field_41759.fieldOf("dir").forGetter(exit -> exit.dir.name())).apply((Applicative)instance, (type, origin, dir) -> Exit.of(ExitType.valueOf(type), origin, Cardinal.of(dir))));

    public static Exit of(ExitType type, Coord origin, Cardinal dir) {
        return new Exit(type, origin, dir);
    }

    private Exit(ExitType type, Coord origin, Cardinal dir) {
        this.type = type;
        this.origin = origin.freeze();
        this.dir = dir;
    }

    public ExitType type() {
        return this.type;
    }

    public Coord origin() {
        return this.origin;
    }

    public Cardinal dir() {
        return this.dir;
    }

    public String toString() {
        return this.type.name() + " " + this.origin.toString() + " " + this.dir.name();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dir, this.origin, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Exit other = (Exit)obj;
        return this.dir == other.dir && Objects.equals(this.origin, other.origin) && this.type == other.type;
    }

    @Override
    public int compareTo(Exit other) {
        if (!this.origin.equals(other.origin)) {
            return this.origin.compareTo(other.origin);
        }
        if (this.dir != other.dir) {
            return this.dir.compareTo(other.dir);
        }
        if (this.type != other.type) {
            return this.type.compareTo(other.type);
        }
        return 0;
    }
}

