/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.layout;

import com.google.gson.JsonElement;
import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.debug.Debug;
import com.greymerk.roguelike.dungeon.Floor;
import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.layout.ExclusionZones;
import com.greymerk.roguelike.dungeon.layout.Exit;
import com.greymerk.roguelike.dungeon.layout.ExitType;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.dungeon.room.RoomProvider;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.settings.dungeon.DungeonSettingsDefault;
import com.greymerk.roguelike.util.math.RandHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class LayoutManager {
    public static final Codec<LayoutManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Coord.CODEC.fieldOf("origin").forGetter(lm -> lm.origin), (App)Coord.CODEC.fieldOf("entry").forGetter(lm -> lm.entry), (App)Codec.list(Floor.CODEC).fieldOf("floors").forGetter(lm -> lm.floors)).apply((Applicative)instance, (origin, entry, floors) -> new LayoutManager((Coord)origin, (Coord)entry, (List<Floor>)floors)));
    private Coord origin;
    private Coord entry;
    private List<Floor> floors;
    private ExclusionZones zones;

    public LayoutManager(Coord origin, Coord entry, int depth) {
        this.origin = origin;
        this.entry = entry;
        this.floors = this.createFloors(entry, depth);
        this.zones = new ExclusionZones();
    }

    public LayoutManager(Coord origin, Coord entry, List<Floor> floors) {
        this.origin = origin;
        this.entry = entry;
        this.floors = floors;
        this.zones = new ExclusionZones();
    }

    public void generate(IWorldEditor editor) {
        int ROOMS_PER_LEVEL = 20;
        DungeonSettingsDefault settings = new DungeonSettingsDefault(Config.ofBoolean(Config.BELOW_SEA_LEVEL) != false ? editor.getInfo().getFirstFloorDepth() : this.entry.getY(), editor.getInfo().getLastFloorDepth());
        for (Floor floor : this.floors) {
            boolean aboveDungeon;
            class_5819 rand = editor.getRandom(floor.getOrigin());
            ILevelSettings levelSettings = settings.getLevel(floor.getOrigin().getY());
            boolean bl = aboveDungeon = Config.ofBoolean(Config.BELOW_SEA_LEVEL) != false && floor.getOrigin().getY() > editor.getInfo().getFirstFloorDepth();
            if (aboveDungeon) {
                this.placeRoom(Room.getInstance(Room.STAIRWAY, levelSettings), rand, floor, false);
                continue;
            }
            this.connectFloorBranches(editor, rand, floor, levelSettings);
            RoomProvider roomProvider = levelSettings.getRooms();
            int numRooms = Math.clamp((long)Config.ofInteger(Config.ROOMS_PER_LEVEL).orElse(20).intValue(), 1, 1000);
            List<Room> rooms = roomProvider.getRooms(rand, numRooms);
            rooms.forEach(r -> this.placeRoom(Room.getInstance(r, levelSettings), rand, floor, rand.method_43056()));
            this.determineExits(editor, rand, floor);
        }
        if (Debug.isOn()) {
            Debug.toFile(editor, "RoguelikeDungeons_" + this.origin.toString().replaceAll(" ", "_") + "_Layout.json", (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow());
        }
    }

    private void determineExits(IWorldEditor editor, class_5819 rand, Floor floor) {
        CellManager cells = floor.getCells();
        cells.forEach(cell -> Cardinal.directions.forEach(dir -> cells.getExitType((Cell)cell, (Cardinal)((Object)((Object)dir))).ifPresent(type -> cell.getOwner().ifPresent(room -> {
            Exit exit = Exit.of(type, cell.getWorldPos(floor.getOrigin()), dir);
            room.addExit(exit);
            if (exit.type() == ExitType.ALCOVE) {
                Cell other = cells.get(cell.getWorldPos(floor.getOrigin()).add((Cardinal)((Object)((Object)dir))));
                other.addWalls(Cardinal.directions);
            }
        }))));
    }

    private void connectFloorBranches(IWorldEditor editor, class_5819 rand, Floor floor, ILevelSettings settings) {
        while (!floor.getCells().isConnected()) {
            CellManager cm = floor.getCells();
            List<Cell> nearest = cm.getNearestPotentials();
            if (nearest.isEmpty()) {
                return;
            }
            nearest.forEach(c -> {
                IRoom room = Room.getInstance(Room.CORRIDOR, settings);
                this.addRoom(room, Cardinal.NORTH, c.getFloorPos(), c.getWorldPos(floor.getOrigin()), floor);
            });
        }
    }

    private void placeRoom(IRoom room, class_5819 rand, Floor floor, boolean shuffle) {
        if (this.findFit(room, rand, floor, true, shuffle)) {
            return;
        }
        this.findFit(room, rand, floor, false, shuffle);
    }

    private boolean findFit(IRoom room, class_5819 rand, Floor floor, boolean avoidZones, boolean shuffle) {
        for (Cell c : room.getCells(Cardinal.NORTH)) {
            if (c.getLevelOffset() + this.floors.indexOf(floor) <= this.floors.size() - 1) continue;
            return false;
        }
        List<Cell> cells = floor.getCells(CellState.POTENTIAL);
        if (shuffle) {
            RandHelper.shuffle(cells, rand);
        } else {
            Collections.sort(cells, (a, b) -> {
                Coord ac = a.getWorldPos(floor.getOrigin());
                Coord bc = b.getWorldPos(floor.getOrigin());
                Double adist = ac.distance(floor.getOrigin());
                Double bdist = bc.distance(floor.getOrigin());
                return Double.compare(adist, bdist);
            });
        }
        for (Cell potential : cells) {
            List<Cardinal> dirs = this.getPotentialDir(floor, potential);
            RandHelper.shuffle(dirs, rand);
            for (Cardinal dir : dirs) {
                Coord wp = potential.getWorldPos(floor.getOrigin());
                if (avoidZones && this.zones.collides(room.getBoundingBox(wp, dir))) continue;
                CellManager rcm = room.getCells(dir);
                if (!floor.getCells().roomFits(potential, rcm)) continue;
                this.addRoom(room, dir, potential.getFloorPos(), wp, floor);
                return true;
            }
        }
        return false;
    }

    private List<Cardinal> getPotentialDir(Floor floor, Cell cell) {
        ArrayList<Cardinal> dirs = new ArrayList<Cardinal>();
        for (Cardinal dir : Cardinal.directions) {
            Coord fp = cell.getFloorPos();
            fp.add(Cardinal.reverse(dir));
            Cell target = floor.getCell(fp);
            if (target.getState() != CellState.OBSTRUCTED || target.hasWall(dir)) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    public void addEntrance(IRoom room) {
        Floor f = this.floors.getFirst();
        Coord wp = f.getOrigin();
        this.addRoom(room, Cardinal.NORTH, Coord.ZERO, wp, f);
    }

    public void addRoom(IRoom toAdd, Cardinal dir, Coord fp, Coord wp, Floor floor) {
        int level = this.floors.indexOf(floor);
        toAdd.setDirection(dir);
        toAdd.setFloorPos(fp);
        toAdd.setWorldPos(wp);
        floor.addRoom(toAdd);
        CellManager cells = toAdd.getCells(dir);
        cells.getLevelOffsets().forEach(offset -> {
            Floor f = this.floors.get(level + offset);
            cells.getByOffset((int)offset).forEach(c -> {
                Coord cfp = c.getFloorPos().withY(0);
                cfp.add(fp);
                f.addCell(Cell.of(cfp, c.getState(), c.getOwner().orElse(null)).addWalls(c.getWalls()));
            });
        });
    }

    private List<Floor> createFloors(Coord entry, int depth) {
        ArrayList<Floor> floors = new ArrayList<Floor>();
        for (int y = entry.getY(); y >= depth; y -= 10) {
            floors.add(Floor.of(entry.withY(y)));
        }
        return floors;
    }

    public List<IRoom> getRooms() {
        return this.floors.stream().flatMap(floor -> StreamSupport.stream(floor.getRooms().spliterator(), false)).toList();
    }

    public class CenterSort
    implements Comparator<Cell> {
        public CenterSort(LayoutManager this$0) {
        }

        @Override
        public int compare(Cell c, Cell other) {
            int distC = (int)c.getFloorPos().distance(Coord.ZERO);
            int distOther = (int)other.getFloorPos().distance(Coord.ZERO);
            return Integer.compare(distC, distOther);
        }
    }
}

