/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.layout.Exit;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.Corridor;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.BrewingStand;
import com.greymerk.roguelike.editor.blocks.Crops;
import com.greymerk.roguelike.editor.blocks.Log;
import com.greymerk.roguelike.editor.blocks.Trapdoor;
import com.greymerk.roguelike.editor.blocks.Wood;
import com.greymerk.roguelike.editor.blocks.slab.Slab;
import com.greymerk.roguelike.editor.blocks.stair.MetaStair;
import com.greymerk.roguelike.editor.blocks.stair.Stair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.factories.BlockCheckers;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ChestType;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.loot.potions.PotionMixture;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class BTeamRoom
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord outside = this.getWorldPos().freeze();
        Coord origin = outside.add(this.direction, 6).freeze();
        class_5819 rand = editor.getRandom(outside);
        this.entry(editor, rand, this.getWorldPos());
        this.clear(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.lamps(editor, rand, origin);
        this.walls(editor, rand, origin);
        this.table(editor, rand, origin);
        this.emeraldB(editor, rand, origin);
        this.decor(editor, rand, origin);
        this.passage(editor, rand, this.getWorldPos());
    }

    private void decor(IWorldEditor editor, class_5819 rand, Coord origin) {
        MetaBlock.of(class_2246.field_10223).set(editor, origin.add(this.direction, 7).add(Cardinal.left(this.direction), 4));
        Optional<ITreasureChest> maybeChest = Treasure.generate(editor, rand, this.settings.getDifficulty(), origin.add(this.direction, 7).add(Cardinal.left(this.direction), 5), Cardinal.reverse(this.direction), Treasure.EMPTY, ChestType.CHEST);
        if (maybeChest.isPresent()) {
            maybeChest.get().setRandomEmptySlot(new class_1799((class_1935)class_1802.field_8834));
        }
        MetaBlock.of(class_2246.field_10504).set(editor, origin.add(Cardinal.right(this.direction), 5).add(this.direction, 7));
        Coord stand = origin.add(Cardinal.right(this.direction), 5).add(this.direction, 7).add(Cardinal.UP);
        BrewingStand.generate(editor, rand, stand, 0, List.of(PotionMixture.getBooze(rand), PotionMixture.getBooze(rand), PotionMixture.getBooze(rand)));
    }

    private void emeraldB(IWorldEditor editor, class_5819 rand, Coord origin) {
        MetaBlock emerald = MetaBlock.of(class_2246.field_10234);
        BoundingBox.of(origin).add(Cardinal.right(this.direction), 5).grow(Cardinal.UP, 4).forEach(pos -> {
            if (pos.getY() % 2 == 0) {
                BoundingBox.of(pos).add(this.direction, 3).grow(this.direction, 2).fill(editor, rand, emerald);
            } else {
                emerald.set(editor, pos.copy().add(this.direction, 2));
                emerald.set(editor, pos.copy().add(this.direction, 5));
            }
        });
    }

    private void table(IWorldEditor editor, class_5819 rand, Coord origin) {
        MetaBlock carpet = MetaBlock.of(class_2246.field_10591);
        MetaStair chair = Stair.of(Stair.NETHERBRICK);
        BoundingBox.of(origin).add(this.direction).grow(Cardinal.orthogonal(this.direction), 4).fill(editor, rand, carpet);
        BoundingBox.of(origin).add(this.direction, 6).grow(Cardinal.orthogonal(this.direction), 4).fill(editor, rand, carpet);
        Cardinal.orthogonal(this.direction).forEach(o -> {
            BoundingBox.of(origin).add(this.direction, 2).add((Cardinal)((Object)o), 4).grow(this.direction, 3).fill(editor, rand, carpet);
            chair.setOrientation(this.direction, false).set(editor, rand, origin.add(this.direction).add((Cardinal)((Object)o)));
            chair.setOrientation(Cardinal.reverse(this.direction), false).set(editor, rand, origin.add(this.direction, 6).add((Cardinal)((Object)o)));
            Stair.of(Stair.SPRUCE).setOrientation((Cardinal)((Object)o), true).fill(editor, rand, BoundingBox.of(origin).add(this.direction, 3).add((Cardinal)((Object)o), 2).grow(this.direction));
        });
        Slab.of(Slab.SPRUCE).upsideDown(true).get().fill(editor, rand, BoundingBox.of(origin).add(this.direction, 3).grow(this.direction).grow(Cardinal.orthogonal(this.direction)));
    }

    private void walls(IWorldEditor editor, class_5819 rand, Coord origin) {
        BlockCheckers panels = new BlockCheckers(Log.get(Wood.SPRUCE, Cardinal.left(this.direction)), Log.get(Wood.SPRUCE, Cardinal.UP));
        BoundingBox.of(origin).add(Cardinal.reverse(this.direction)).add(Cardinal.UP).grow(Cardinal.orthogonal(this.direction), 5).grow(Cardinal.UP, 3).fill(editor, rand, panels);
        BoundingBox.of(origin).add(Cardinal.reverse(this.direction)).grow(Cardinal.orthogonal(this.direction), 5).fill(editor, rand, MetaBlock.of(class_2246.field_9975));
        BoundingBox.of(origin).add(this.direction, 8).add(Cardinal.UP).grow(Cardinal.orthogonal(this.direction), 5).grow(Cardinal.UP, 3).fill(editor, rand, panels);
        BoundingBox.of(origin).add(this.direction, 8).grow(Cardinal.orthogonal(this.direction), 5).fill(editor, rand, MetaBlock.of(class_2246.field_9975));
        BoundingBox.of(origin).add(Cardinal.right(this.direction), 6).grow(this.direction, 7).fill(editor, rand, MetaBlock.of(class_2246.field_9975));
        BoundingBox.of(origin).add(Cardinal.right(this.direction), 6).add(Cardinal.UP).grow(this.direction, 7).grow(Cardinal.UP, 4).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(Cardinal.left(this.direction), 6).grow(this.direction, 7).fill(editor, rand, MetaBlock.of(class_2246.field_9975));
        BoundingBox.of(origin).add(Cardinal.left(this.direction), 6).add(Cardinal.UP, 4).grow(this.direction, 7).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(Cardinal.left(this.direction), 6).add(Cardinal.UP).grow(Cardinal.UP, 2).grow(this.direction, 7).fill(editor, rand, MetaBlock.of(class_2246.field_10504));
        BoundingBox.of(origin).add(Cardinal.left(this.direction), 6).add(this.direction, 2).grow(this.direction, 3).fill(editor, rand, MetaBlock.of(class_2246.field_10179));
        BoundingBox.of(origin).add(Cardinal.left(this.direction), 6).add(this.direction, 2).add(Cardinal.UP).grow(Cardinal.UP, 2).grow(this.direction, 3).fill(editor, rand, MetaBlock.of(class_2246.field_10146));
        Log.get(Wood.JUNGLE, Cardinal.left(this.direction)).set(editor, origin.add(Cardinal.left(this.direction), 6).add(this.direction).add(Cardinal.UP, 2));
        Log.get(Wood.JUNGLE, Cardinal.left(this.direction)).set(editor, origin.add(Cardinal.left(this.direction), 6).add(this.direction, 6).add(Cardinal.UP, 2));
        MetaBlock cocao = Crops.getCocao(Cardinal.left(this.direction));
        cocao.set(editor, origin.add(Cardinal.left(this.direction), 5).add(this.direction).add(Cardinal.UP, 2));
        cocao.set(editor, origin.add(Cardinal.left(this.direction), 5).add(this.direction, 6).add(Cardinal.UP, 2));
    }

    private void lamps(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.orthogonal(this.direction).forEach(o -> {
            this.lamp(editor, rand, origin.add((Cardinal)((Object)o), 3).freeze(), this.direction);
            this.lamp(editor, rand, origin.add((Cardinal)((Object)o), 3).add(this.direction, 7).freeze(), Cardinal.reverse(this.direction));
        });
    }

    private void lamp(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        MetaBlock spruce = MetaBlock.of(class_2246.field_9975);
        MetaBlock fence = MetaBlock.of(class_2246.field_10020);
        spruce.set(editor, origin);
        fence.set(editor, origin.add(Cardinal.UP));
        MetaBlock.of(class_2246.field_10171).set(editor, origin.add(Cardinal.UP, 2));
        Cardinal.directions.forEach(d -> {
            if (d != Cardinal.reverse(dir)) {
                Trapdoor.getWooden(Wood.OAK, Cardinal.reverse(d), true, true).set(editor, origin.add(Cardinal.UP, 2).add((Cardinal)((Object)d)));
            }
        });
        fence.set(editor, origin.add(Cardinal.UP, 3));
        spruce.set(editor, origin.add(Cardinal.UP, 4));
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        MetaStair stair = Stair.of(Stair.SPRUCE);
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(this.direction, 7).grow(Cardinal.orthogonal(this.direction), 5).fill(editor, rand, MetaBlock.of(class_2246.field_10056));
        stair.setOrientation(this.direction, true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.UP, 5).add(this.direction, 2).grow(Cardinal.orthogonal(this.direction), 2));
        stair.setOrientation(Cardinal.reverse(this.direction), true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.UP, 5).add(this.direction, 5).grow(Cardinal.orthogonal(this.direction), 2));
        Cardinal.orthogonal(this.direction).forEach(o -> stair.setOrientation(Cardinal.reverse(o), true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.UP, 5).add((Cardinal)((Object)o), 3).add(this.direction, 2).grow(this.direction, 3)));
        BoundingBox.of(origin).add(Cardinal.UP, 5).add(this.direction, 3).grow(this.direction).grow(Cardinal.orthogonal(this.direction), 2).fill(editor, rand, MetaBlock.of(class_2246.field_10524));
        stair.setOrientation(this.direction, true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.UP, 4).grow(Cardinal.orthogonal(this.direction), 5));
        stair.setOrientation(Cardinal.reverse(this.direction), true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.UP, 4).add(this.direction, 7).grow(Cardinal.orthogonal(this.direction), 5));
        BoundingBox.of(origin).add(Cardinal.UP, 4).add(Cardinal.left(this.direction), 5).add(this.direction).grow(this.direction, 5).fill(editor, rand, Slab.of(Slab.SPRUCE).upsideDown(true).get());
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(this.direction, 7).grow(Cardinal.orthogonal(this.direction), 5).grow(Cardinal.UP, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).grow(this.direction, 7).grow(Cardinal.orthogonal(this.direction), 5).add(Cardinal.DOWN).fill(editor, rand, MetaBlock.of(class_2246.field_10445));
    }

    private void passage(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).add(this.direction, 3).grow(Cardinal.orthogonal(this.direction), 2).grow(Cardinal.UP, 3).grow(Cardinal.DOWN).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(this.direction, 4).grow(Cardinal.orthogonal(this.direction)).grow(Cardinal.UP, 2).grow(this.direction).grow(Cardinal.DOWN).fill(editor, rand, MetaBlock.of(class_2246.field_10445));
        BoundingBox.of(origin).add(this.direction, 4).grow(Cardinal.UP).grow(this.direction).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(this.direction, 3).grow(Cardinal.UP).grow(this.direction, 2).fill(editor, rand, MetaBlock.of(class_2246.field_10255));
    }

    private void entry(IWorldEditor editor, class_5819 rand, Coord origin) {
        Corridor cor = new Corridor();
        this.exits.forEach(e -> cor.addExit((Exit)e));
        cor.setDirection(this.direction);
        cor.setLevelSettings(this.settings);
        cor.worldPos = this.worldPos.copy();
        cor.generate(editor);
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        Coord origin = Coord.ZERO;
        CellManager cells = new CellManager();
        cells.add(Cell.of(origin.copy(), CellState.OBSTRUCTED, this));
        cells.add(Cell.of(origin.copy().add(dir), CellState.OBSTRUCTED, this));
        cells.add(Cell.of(origin.copy().add(dir, 2), CellState.OBSTRUCTED, this).addWall(dir));
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            cells.add(Cell.of(origin.copy().add(dir).add(o), CellState.OBSTRUCTED, this).addWall(Cardinal.reverse(dir)).addWall(o));
            cells.add(Cell.of(origin.copy().add(dir, 2).add(o), CellState.OBSTRUCTED, this).addWall(dir).addWall(o));
        }
        for (Cardinal d : Cardinal.directions) {
            if (d == dir) continue;
            cells.add(Cell.of(origin.copy().add(d), CellState.POTENTIAL, this));
        }
        return cells;
    }

    @Override
    public String getName() {
        return Room.BTEAM.name();
    }
}

