/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import java.util.List;
import net.minecraft.class_5819;

public class BalconyRoom
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().add(this.direction, 6).freeze();
        class_5819 rand = editor.getRandom(origin);
        this.clear(editor, rand, origin);
        this.mainWalls(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.upperRoom(editor, rand, origin);
        this.lowerRoom(editor, rand, origin.add(Cardinal.DOWN, 10).freeze());
        this.supports(editor, rand, origin.add(Cardinal.DOWN, 10).freeze());
        this.generateExits(editor, rand);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> {
            CellSupport.generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 6));
            CellSupport.generate(editor, rand, this.theme, origin.add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6));
        });
    }

    private void lowerRoom(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 8).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 8).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 7).add(Cardinal.UP, 8).grow(Cardinal.orthogonal(dir), 8).fill(editor, rand, this.theme.getPrimary().getWall());
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).fill(editor, rand, BoundingBox.of(origin).add((Cardinal)((Object)dir), 6).add(Cardinal.UP, 8).grow(Cardinal.orthogonal(dir), 6));
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add(Cardinal.left(dir), 8), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            Cardinal.orthogonal(dir).forEach(o -> {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 3), this.theme, 4, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 4), this.theme, 2, List.of(Cardinal.reverse(dir), o));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 4).add(Cardinal.UP, 3), this.theme, 4, List.of(Cardinal.reverse(dir), o));
                this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 3).add(Cardinal.UP, 2));
                this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 7).add((Cardinal)((Object)((Object)o)), 3).add(Cardinal.UP, 7));
                List.of(Integer.valueOf(2), Integer.valueOf(4)).forEach(i -> {
                    this.theme.getPrimary().getWall().set(editor, rand, origin.add((Cardinal)((Object)dir), 6).add(Cardinal.UP, 8).add((Cardinal)((Object)((Object)o)), (int)i));
                    this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add((Cardinal)((Object)dir), 5).add(Cardinal.UP, 8).add((Cardinal)((Object)((Object)o)), (int)i));
                });
            });
        });
    }

    private void upperRoom(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 8).grow(Cardinal.orthogonal(dir), 8).fill(editor, rand, this.theme.getPrimary().getWall());
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add(Cardinal.left(dir), 8), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 4).add(Cardinal.left(dir), 4), this.theme, 2, List.of(dir, Cardinal.left(dir)));
            Cardinal.orthogonal(dir).forEach(o -> {
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 4), this.theme, 2, List.of(Cardinal.reverse(dir), o));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 4).add((Cardinal)((Object)((Object)o)), 2), this.theme, 2, List.of(dir));
                Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 4).add((Cardinal)((Object)((Object)o)), 2).add(Cardinal.UP, 3), this.theme, 0, List.of(Cardinal.reverse(dir), Cardinal.reverse(o)));
                BoundingBox.of(origin).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 3).add((Cardinal)((Object)((Object)o)), 4).grow((Cardinal)((Object)dir), 4).fill(editor, rand, this.theme.getPrimary().getWall());
                BoundingBox.of(origin).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 5).add((Cardinal)((Object)((Object)o)), 2).grow((Cardinal)((Object)dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
            });
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 4).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, IronBar.get(), Fill.AIR.and(Fill.SUPPORTED));
        });
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)).forEach(i -> {
            BoundingBox.of(origin).add(Cardinal.UP, 4).add((Cardinal)((Object)dir), (int)i).grow(Cardinal.orthogonal(dir), 9).fill(editor, rand, this.theme.getPrimary().getWall());
            List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8)).forEach(j -> Cardinal.orthogonal(dir).forEach(o -> this.theme.getPrimary().getWall().set(editor, rand, origin.add(Cardinal.UP, 5).add((Cardinal)((Object)dir), (int)i).add((Cardinal)((Object)((Object)((Object)((Object)o)))), (int)j), Fill.AIR.or(Fill.LIQUID))));
        }));
    }

    private void mainWalls(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).add(Cardinal.DOWN, 11).grow(Cardinal.directions, 8).fill(editor, rand, this.settings.getTheme().getPrimary().getFloor());
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 8).fill(editor, rand, this.settings.getTheme().getPrimary().getFloor());
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 3).fill(editor, rand, Air.get());
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).grow(Cardinal.orthogonal(dir), 9).grow(Cardinal.UP, 5).grow(Cardinal.DOWN, 11).fill(editor, rand, this.theme.getPrimary().getWall()));
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 8).grow(Cardinal.UP, 4).grow(Cardinal.DOWN, 10).fill(editor, rand, Air.get());
    }

    @Override
    public BoundingBox getBoundingBox(Coord origin, Cardinal dir) {
        return BoundingBox.of(origin.copy().add(dir, 6)).grow(Cardinal.directions, 10).grow(Cardinal.UP, 6).grow(Cardinal.DOWN, 11);
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        Coord origin = Coord.ZERO.add(dir).freeze();
        CellManager cells = new CellManager();
        BoundingBox.of(origin).grow(Cardinal.directions).grow(Cardinal.DOWN).forEach(pos -> cells.add(Cell.of(pos, CellState.OBSTRUCTED, this)));
        Cardinal.directions.forEach(d -> BoundingBox.of(origin).add((Cardinal)((Object)d), 2).grow(Cardinal.orthogonal(d)).grow(Cardinal.DOWN).forEach(pos -> cells.add(Cell.of(pos, CellState.POTENTIAL, this))));
        return cells;
    }

    @Override
    public String getName() {
        return Room.BALCONY.name();
    }
}

