/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.EnderChest;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.theme.IBlockSet;
import com.greymerk.roguelike.theme.ITheme;
import com.greymerk.roguelike.theme.ThemeBase;
import com.greymerk.roguelike.theme.blocksets.EnderBlocks;
import net.minecraft.class_5819;

public class EnderRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 6);
        class_5819 rand = editor.getRandom(origin);
        EnderBlocks blocks = new EnderBlocks();
        this.clear(editor, rand, origin, blocks);
        this.walls(editor, rand, origin, blocks);
        this.pillars(editor, rand, origin, blocks);
        this.floor(editor, rand, origin, blocks);
        this.ceiling(editor, rand, origin, blocks);
        this.enderchest(editor, rand, origin, blocks);
        this.supports(editor, rand, origin, blocks);
        Spawner.generate(editor, rand, this.settings.getDifficulty(), origin, Spawner.ENDERMAN);
        this.generateExits(editor, rand);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        EnderTheme ender = new EnderTheme(this);
        CellSupport.generate(editor, rand, ender, origin);
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = origin.copy();
            pos.add(dir, 6);
            CellSupport.generate(editor, rand, ender, pos);
            pos.add(Cardinal.left(dir), 6);
            CellSupport.generate(editor, rand, ender, pos);
        }
    }

    private void enderchest(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        Coord pos = origin.copy();
        Cardinal dir = Cardinal.randDirs(rand).get(0);
        pos.add(dir, 6);
        Cardinal o = rand.method_43056() ? Cardinal.left(dir) : Cardinal.right(dir);
        pos.add(o, 8);
        EnderChest.set(editor, Cardinal.reverse(o), pos);
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(Cardinal.UP, 6).add(dir, 2);
            bb.grow(Cardinal.orthogonal(dir), 4);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
            bb.add(dir, 2);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 4).add(Cardinal.UP, 5);
            bb.grow(Cardinal.orthogonal(dir), 7);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
            bb.add(dir, 4);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                bb = BoundingBox.of(origin.copy());
                bb.add(dir, 3).add(o, 2).add(Cardinal.UP, 5);
                bb.grow(dir, 4);
                RectSolid.fill(editor, rand, bb, blocks.getWall());
            }
            bb = BoundingBox.of(origin.copy());
            bb.add(Cardinal.UP, 6).add(dir, 5).grow(dir, 3).grow(Cardinal.left(dir), 4).grow(Cardinal.right(dir), 8);
            RectSolid.fill(editor, rand, bb, blocks.getWall(), Fill.SOLID);
        }
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.UP, 7).grow(Cardinal.directions, 4);
        RectSolid.fill(editor, rand, bb, blocks.getWall(), Fill.SOLID);
    }

    private void floor(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 7);
        bb.add(Cardinal.DOWN);
        RectSolid.fill(editor, rand, bb, blocks.getFloor());
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 8).add(Cardinal.DOWN);
            bb.grow(Cardinal.orthogonal(dir), 8).grow(dir);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 2).add(Cardinal.left(dir), 2).add(Cardinal.DOWN);
            bb.grow(dir, 2).grow(Cardinal.left(dir), 2);
            RectSolid.fill(editor, rand, bb, blocks.getWall());
        }
    }

    private void pillars(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        Coord p;
        Coord pos;
        BoundingBox bb;
        IStair stair = blocks.getStair();
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 3).add(Cardinal.left(dir), 3);
            bb.grow(Cardinal.UP, 7);
            RectSolid.fill(editor, rand, bb, blocks.getPillar());
            pos = origin.copy();
            pos.add(dir, 3).add(Cardinal.left(dir), 3).add(Cardinal.UP, 3);
            for (Cardinal d : Cardinal.directions) {
                p = pos.copy();
                p.add(d);
                stair.setOrientation(d, true).set(editor, rand, p);
                p.add(Cardinal.UP);
                blocks.getWall().set(editor, rand, p);
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            bb = BoundingBox.of(origin.copy());
            bb.add(dir, 8).add(Cardinal.left(dir), 8);
            bb.grow(Cardinal.UP, 6);
            RectSolid.fill(editor, rand, bb, blocks.getPillar());
            pos = origin.copy();
            pos.add(dir, 8).add(Cardinal.left(dir), 8).add(Cardinal.UP, 4);
            for (Cardinal d : Cardinal.directions) {
                p = pos.copy().add(d);
                stair.setOrientation(d, true).set(editor, rand, p, Fill.AIR);
            }
            for (Cardinal orth : Cardinal.orthogonal(dir)) {
                for (Cardinal o : Cardinal.orthogonal(dir)) {
                    bb = BoundingBox.of(origin.copy());
                    bb.add(dir, 8).add(orth, 3);
                    bb.add(o);
                    bb.grow(Cardinal.UP, 6);
                    RectSolid.fill(editor, rand, bb, blocks.getPillar());
                    pos = origin.copy();
                    pos.add(dir, 8).add(orth, 3).add(o).add(Cardinal.UP, 4);
                    stair.setOrientation(o, true).set(editor, rand, pos.copy().add(o));
                    stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos.copy().add(Cardinal.reverse(dir)));
                }
            }
        }
    }

    private void walls(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 9).grow(Cardinal.orthogonal(dir), 9).grow(Cardinal.UP, 5).grow(Cardinal.DOWN);
            RectSolid.fill(editor, rand, bb, blocks.getWall(), Fill.SOLID);
        }
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin, IBlockSet blocks) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 8);
        bb.grow(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 4);
        bb.add(Cardinal.UP, 6);
        RectSolid.fill(editor, rand, bb, Air.get());
    }

    @Override
    public String getName() {
        return Room.ENDER.name();
    }

    private class EnderTheme
    extends ThemeBase
    implements ITheme {
        public EnderTheme(EnderRoom enderRoom) {
            this.secondary = this.primary = new EnderBlocks();
        }

        @Override
        public String getName() {
            return "Ender";
        }
    }
}

