/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.layout.Exit;
import com.greymerk.roguelike.dungeon.layout.ExitType;
import com.greymerk.roguelike.dungeon.room.AbstractRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Candle;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_5819;

public class ImperialStairway
extends AbstractRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.getWorldPos().add(this.direction, 12).freeze();
        class_5819 rand = editor.getRandom(this.getWorldPos());
        this.clear(editor, rand, origin);
        this.walls(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.upperLevel(editor, rand, origin);
        this.stairway(editor, rand, origin, Cardinal.reverse(this.direction));
        this.tunnels(editor, rand, origin.add(Cardinal.DOWN, 10).freeze(), Cardinal.reverse(this.direction));
        this.lowerRoom(editor, rand, origin.add(Cardinal.DOWN, 10).freeze());
        this.supports(editor, rand, origin.add(Cardinal.DOWN, 10).freeze());
        this.generateExits(editor, rand);
    }

    private void supports(IWorldEditor editor, class_5819 rand, Coord origin) {
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(i -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i));
            List.of(Integer.valueOf(6), Integer.valueOf(12)).forEach(j -> CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), (int)i).add(Cardinal.left(dir), (int)j)));
        }));
    }

    private void lowerRoom(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).add(this.direction, 14).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(this.direction), 14).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(this.direction, 13).add(Cardinal.UP, 7).grow(Cardinal.orthogonal(this.direction), 14).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(this.direction, 12).add(Cardinal.UP, 8).grow(Cardinal.orthogonal(this.direction), 14).fill(editor, rand, this.theme.getPrimary().getWall());
        Cardinal.orthogonal(this.direction).forEach(o -> {
            BoundingBox.of(origin).add(Cardinal.reverse(this.direction), 2).add((Cardinal)((Object)o), 14).add(Cardinal.UP, 3).grow(this.direction, 16).grow(Cardinal.UP, 5).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.reverse(this.direction), 2).add((Cardinal)((Object)o), 13).add(Cardinal.UP, 7).grow(this.direction, 16).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.reverse(this.direction), 2).add((Cardinal)((Object)o), 12).add(Cardinal.UP, 8).grow(this.direction, 16).fill(editor, rand, this.theme.getPrimary().getWall());
            List.of(Integer.valueOf(-2), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10)).forEach(i -> this.buttress(editor, rand, origin.add(this.direction, (int)i).add((Cardinal)((Object)o), 10).freeze(), (Cardinal)((Object)o)));
            List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10)).forEach(i -> this.buttress(editor, rand, origin.add(this.direction, 10).add((Cardinal)((Object)o), (int)i).freeze(), this.direction));
            this.coveArch(editor, rand, origin.add((Cardinal)((Object)o), 10).freeze(), (Cardinal)((Object)o));
            this.coveArch(editor, rand, origin.add((Cardinal)((Object)o), 10).add(this.direction, 6).freeze(), (Cardinal)((Object)o));
            this.coveArch(editor, rand, origin.add(this.direction, 10).add((Cardinal)((Object)o), 6).freeze(), this.direction);
            this.inlay(editor, rand, origin.add((Cardinal)((Object)o), 10).add(this.direction, 3).freeze(), (Cardinal)((Object)o));
            this.inlay(editor, rand, origin.add((Cardinal)((Object)o), 10).add(this.direction, 9).freeze(), (Cardinal)((Object)o));
            this.inlay(editor, rand, origin.add((Cardinal)((Object)o), 3).add(this.direction, 10).freeze(), this.direction);
            this.inlay(editor, rand, origin.add((Cardinal)((Object)o), 9).add(this.direction, 10).freeze(), this.direction);
            Pillar.generate(editor, rand, origin.add(this.direction, 14).add((Cardinal)((Object)o), 14), this.theme.getPrimary(), 2, List.of(Cardinal.reverse(o), Cardinal.reverse(this.direction)));
            this.theme.getPrimary().getStair().setOrientation((Cardinal)((Object)o), true).set(editor, rand, origin.add(this.direction, 14).add((Cardinal)((Object)o), 11).add(Cardinal.UP, 2));
            this.theme.getPrimary().getStair().setOrientation(this.direction, true).set(editor, rand, origin.add(this.direction, 11).add((Cardinal)((Object)o), 14).add(Cardinal.UP, 2));
            this.theme.getPrimary().getWall().set(editor, rand, origin.add(this.direction, 10).add((Cardinal)((Object)o), 10).add(Cardinal.UP, 8));
        });
        this.coveArch(editor, rand, origin.add(this.direction, 10).freeze(), this.direction);
    }

    private void inlay(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(dir, 4).add(Cardinal.UP, 2));
        IntStream.range(0, 3).forEach(i -> this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(dir, 1 + i).add(Cardinal.UP, 8 - i)));
    }

    private void coveArch(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Cardinal.orthogonal(dir).forEach(o -> {
            IntStream.range(0, 3).forEach(i -> this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add(dir, 1 + i).add(Cardinal.UP, 8 - i).add((Cardinal)((Object)o))));
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.add(dir, 4).add(Cardinal.UP, 2).add((Cardinal)((Object)o)));
        });
    }

    private void buttress(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).add(dir, 4).grow(Cardinal.UP).fill(editor, rand, this.theme.getPrimary().getPillar());
        this.theme.getPrimary().getWall().set(editor, rand, origin.add(dir, 4).add(Cardinal.UP, 2));
        this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(dir, 3).add(Cardinal.UP, 2));
        BoundingBox.of(origin).add(dir, 3).add(Cardinal.UP, 3).grow(Cardinal.UP, 2).fill(editor, rand, this.theme.getPrimary().getWall());
        IntStream.range(0, 3).forEach(i -> {
            Coord pos = origin.add(dir, i).add(Cardinal.UP, 8 - i);
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
            this.theme.getPrimary().getWall().set(editor, rand, pos.add(dir));
        });
    }

    private void tunnels(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        this.cell(editor, rand, origin.add(dir, 6).freeze(), List.of(Exit.of(ExitType.ALCOVE, origin.add(dir, 6), Cardinal.left(dir)), Exit.of(ExitType.ALCOVE, origin.add(dir, 6), Cardinal.right(dir)), Exit.of(ExitType.DOOR, origin.add(dir, 6), dir)));
        this.cell(editor, rand, origin.add(dir, 12).freeze(), List.of(Exit.of(ExitType.DOOR, origin.add(dir, 6), Cardinal.left(dir)), Exit.of(ExitType.DOOR, origin.add(dir, 6), Cardinal.right(dir))));
        Cardinal.orthogonal(dir).forEach(o -> {
            this.cell(editor, rand, origin.add(dir, 12).add((Cardinal)((Object)o), 6).freeze(), List.of(Exit.of(ExitType.DOOR, origin.add(dir, 12).add((Cardinal)((Object)o), 6), o), Exit.of(ExitType.WALL, origin.add(dir, 12).add((Cardinal)((Object)o), 6), Cardinal.reverse(dir))));
            this.cell(editor, rand, origin.add(dir, 12).add((Cardinal)((Object)o), 12).freeze(), List.of(Exit.of(ExitType.DOOR, origin.add(dir, 12).add((Cardinal)((Object)o), 12), Cardinal.reverse(dir))));
            this.cell(editor, rand, origin.add(dir, 6).add((Cardinal)((Object)o), 12).freeze(), List.of(Exit.of(ExitType.DOOR, origin.add(dir, 6).add((Cardinal)((Object)o), 12), Cardinal.reverse(dir)), Exit.of(ExitType.WALL, origin.add(dir, 6).add((Cardinal)((Object)o), 12), Cardinal.reverse(o))));
        });
    }

    private void cell(IWorldEditor editor, class_5819 rand, Coord origin, List<Exit> exits) {
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 2).grow(Cardinal.orthogonal(dir)).grow(Cardinal.left(dir)).fill(editor, rand, this.theme.getPrimary().getWall()));
        Cardinal.directions.forEach(dir -> Pillar.generate(editor, rand, origin.copy().add((Cardinal)((Object)dir), 2).add(Cardinal.left(dir), 2), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir))));
        exits.forEach(exit -> {
            if (exit.type() == ExitType.DOOR) {
                Fragment.generate(Fragment.ARCH, editor, rand, this.settings, origin, exit.dir());
            }
            if (exit.type() == ExitType.ALCOVE) {
                this.settings.getAlcove(rand).generate(editor, rand, this.settings, origin, exit.dir());
            }
            if (exit.type() == ExitType.WALL) {
                this.settings.getWallFragment(rand).generate(editor, rand, this.settings, origin, exit.dir());
            }
        });
    }

    private void stairway(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        BoundingBox.of(origin).add(Cardinal.DOWN, 6).add(dir, 4).grow(Cardinal.orthogonal(dir), 14).grow(dir, 10).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(Cardinal.DOWN, 4).add(dir, 3).grow(Cardinal.orthogonal(dir), 2).grow(Cardinal.DOWN).grow(dir, 7).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(dir, 11).add(Cardinal.DOWN, 2).grow(Cardinal.DOWN, 3).grow(dir, 3).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
        BoundingBox.of(origin).add(dir, 10).add(Cardinal.DOWN, 2).grow(Cardinal.orthogonal(dir), 9).fill(editor, rand, this.theme.getPrimary().getWall());
        Cardinal.orthogonal(dir).forEach(o -> {
            BoundingBox.of(origin).add(Cardinal.DOWN, 10).add(dir, 3).add((Cardinal)((Object)o), 3).grow(dir, 6).grow((Cardinal)((Object)o), 6).grow(Cardinal.UP, 3).fill(editor, rand, this.theme.getPrimary().getWall());
            Pillar.generate(editor, rand, origin.add(Cardinal.DOWN, 7).add(dir, 3).add((Cardinal)((Object)o), 2), this.theme, 1, List.of(Cardinal.reverse(o)));
            this.steps(editor, rand, origin.add(Cardinal.DOWN, 10).add((Cardinal)((Object)o), 6).freeze(), dir, 5);
            this.steps(editor, rand, origin.add(Cardinal.DOWN, 5).add((Cardinal)((Object)o), 4).add(dir, 6).freeze(), Cardinal.reverse(o), 2);
        });
        this.steps(editor, rand, origin.add(Cardinal.DOWN, 3).add(dir, 8).freeze(), dir, 3);
        Cardinal.orthogonal(dir).forEach(o -> {
            BoundingBox.of(origin).add(dir, 3).add((Cardinal)((Object)o), 11).add(Cardinal.DOWN, 5).grow(dir, 7).grow((Cardinal)((Object)o), 3).grow(Cardinal.UP, 3).fill(editor, rand, this.theme.getPrimary().getWall());
            this.archShelf(editor, rand, origin.add(Cardinal.DOWN, 5).add(dir, 6).add((Cardinal)((Object)o), 8).freeze(), (Cardinal)((Object)o));
            this.archShelf(editor, rand, origin.add(Cardinal.DOWN, 5).add(dir, 8).add((Cardinal)((Object)o), 6).freeze(), dir);
            this.theme.getPrimary().getWall().set(editor, rand, origin.add((Cardinal)((Object)o), 2).add(dir, 4).add(Cardinal.DOWN, 3));
            Candle.generate(editor, rand, origin.add((Cardinal)((Object)o), 2).add(dir, 4).add(Cardinal.DOWN, 2));
        });
        BoundingBox.of(origin).add(dir, 3).add(Cardinal.DOWN, 3).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, IronBar.get());
        Cardinal.orthogonal(dir).forEach(o -> {
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(Cardinal.DOWN, 8).add(dir, 3).add((Cardinal)((Object)o), 2));
            this.theme.getPrimary().getWall().set(editor, rand, origin.add(Cardinal.DOWN, 7).add(dir, 3).add((Cardinal)((Object)o), 2));
            this.theme.getPrimary().getStair().setOrientation((Cardinal)((Object)o), false).set(editor, rand, origin.add(Cardinal.DOWN, 6).add(dir, 3).add((Cardinal)((Object)o), 3));
            BoundingBox.of(origin).add(Cardinal.DOWN, 6).add(dir, 3).add((Cardinal)((Object)o), 10).grow((Cardinal)((Object)o), 4).fill(editor, rand, this.theme.getPrimary().getWall());
            BoundingBox.of(origin).add(Cardinal.DOWN, 5).add(dir, 9).add((Cardinal)((Object)o), 9).grow(dir).grow((Cardinal)((Object)o)).grow(Cardinal.UP, 4).fill(editor, rand, this.theme.getPrimary().getWall());
        });
    }

    private void archShelf(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Cardinal.orthogonal(dir).forEach(o -> Pillar.generate(editor, rand, origin.add(dir, 2).add((Cardinal)((Object)o), 2), this.theme, 2, List.of(Cardinal.reverse(o))));
        BoundingBox.of(origin).add(dir, 2).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
        this.settings.getWallFragment(rand).generate(editor, rand, this.settings, origin, dir);
    }

    private void steps(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir, int count) {
        IntStream.range(0, count).forEach(i -> {
            this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), false).fill(editor, rand, BoundingBox.of(origin).add(dir, i).add(Cardinal.UP, i).grow(Cardinal.orthogonal(dir)));
            Cardinal.orthogonal(dir).forEach(o -> {
                this.theme.getPrimary().getWall().set(editor, rand, origin.add(dir, i).add(Cardinal.UP, i).add((Cardinal)((Object)((Object)o)), 2));
                if (rand.method_43056()) {
                    Candle.generate(editor, rand, origin.add(dir, i).add(Cardinal.UP, i + 1).add((Cardinal)((Object)((Object)o)), 2), Fill.AIR);
                }
            });
            if (i > 0) {
                BoundingBox.of(origin).add(dir, i).grow(Cardinal.UP, i - 1).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, this.theme.getPrimary().getWall());
            }
        });
    }

    private void upperLevel(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> {
            BoundingBox.of(origin).add((Cardinal)((Object)dir), 10).add(Cardinal.DOWN).grow((Cardinal)((Object)dir), 4).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall());
            List.of(Integer.valueOf(10), Integer.valueOf(14)).forEach(i -> BoundingBox.of(origin).add((Cardinal)((Object)dir), (int)i).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall()));
            Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add(Cardinal.left(dir), 14), this.theme, 2, List.of(Cardinal.reverse(dir), Cardinal.right(dir)));
            Cardinal.orthogonal(dir).forEach(o -> {
                List.of(Integer.valueOf(3), Integer.valueOf(9)).forEach(i -> Cardinal.orthogonal(dir).forEach(orth -> {
                    Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 14).add((Cardinal)((Object)((Object)o)), (int)i).add((Cardinal)((Object)((Object)((Object)((Object)orth))))), this.theme, 2, List.of(Cardinal.reverse(dir), orth));
                    Pillar.generate(editor, rand, origin.add((Cardinal)((Object)dir), 10).add((Cardinal)((Object)((Object)o)), (int)i).add((Cardinal)((Object)((Object)((Object)((Object)orth))))), this.theme, 2, List.of(dir, Cardinal.reverse(dir), orth));
                    BoundingBox.of(origin).add((Cardinal)((Object)dir), 9).add(Cardinal.UP, 3).add((Cardinal)((Object)((Object)o)), (int)i).add((Cardinal)((Object)((Object)((Object)((Object)orth))))).grow((Cardinal)((Object)dir), 4).fill(editor, rand, this.theme.getPrimary().getWall());
                }));
                List.of(Integer.valueOf(2), Integer.valueOf(4)).forEach(i -> this.theme.getPrimary().getStair().setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.add(Cardinal.UP, 3).add((Cardinal)((Object)dir), 8).add((Cardinal)((Object)((Object)o)), (int)i)));
            });
        });
        List.of(this.direction, Cardinal.left(this.direction), Cardinal.right(this.direction)).forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 10).grow(Cardinal.orthogonal(dir), 10).fill(editor, rand, IronBar.get(), Fill.AIR.and(Fill.SUPPORTED)));
        Cardinal.orthogonal(this.direction).forEach(o -> BoundingBox.of(origin).add(Cardinal.reverse(this.direction), 10).add((Cardinal)((Object)o), 3).grow((Cardinal)((Object)o), 6).fill(editor, rand, IronBar.get(), Fill.AIR.and(Fill.SUPPORTED)));
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(14)).forEach(i -> BoundingBox.of(origin).add(Cardinal.UP, 4).add((Cardinal)((Object)dir), (int)i).grow(Cardinal.orthogonal(dir), 14).fill(editor, rand, this.theme.getPrimary().getWall())));
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions, 14).fill(editor, rand, this.theme.getPrimary().getWall(), Fill.SOLID);
    }

    private void walls(IWorldEditor editor, class_5819 rand, Coord origin) {
        Cardinal.directions.forEach(dir -> BoundingBox.of(origin).add((Cardinal)((Object)dir), 15).grow(Cardinal.orthogonal(dir), 15).grow(Cardinal.UP, 3).grow(Cardinal.DOWN, 11).fill(editor, rand, this.theme.getPrimary().getWall()));
        BoundingBox.of(origin).add(Cardinal.DOWN, 11).grow(Cardinal.directions, 14).fill(editor, rand, this.theme.getPrimary().getFloor());
    }

    private void clear(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox.of(origin).grow(Cardinal.directions, 14).grow(Cardinal.UP, 4).grow(Cardinal.DOWN, 10).fill(editor, rand, Air.get());
    }

    @Override
    public IBounded getBoundingBox(Coord origin, Cardinal dir) {
        return BoundingBox.of(origin).add(dir, 12).grow(Cardinal.UP, 6).grow(Cardinal.DOWN, 12).grow(Cardinal.directions, 15);
    }

    @Override
    public String getName() {
        return Room.IMPERIAL_STAIRWAY.name();
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        CellManager cells = new CellManager();
        BoundingBox.of(Coord.ZERO).add(dir, 2).grow(Cardinal.directions, 2).grow(Cardinal.DOWN).forEach(pos -> cells.add(Cell.of(pos, CellState.OBSTRUCTED, this)));
        Cardinal.directions.forEach(d -> BoundingBox.of(Coord.ZERO).add(dir, 2).add((Cardinal)((Object)d), 3).grow(Cardinal.orthogonal(d), 2).grow(Cardinal.DOWN).forEach(pos -> cells.add(Cell.of(pos, CellState.POTENTIAL, this))));
        return cells;
    }
}

