/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.Pillar;
import com.greymerk.roguelike.dungeon.room.AbstractMediumRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Candle;
import com.greymerk.roguelike.editor.blocks.Furnace;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ChestType;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5819;

public class KitchenRoom
extends AbstractMediumRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 6).freeze();
        class_5819 rand = editor.getRandom(origin);
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        IBlockFactory pillar = this.theme.getPrimary().getPillar();
        BoundingBox.of(origin).grow(Cardinal.directions, 8).grow(Cardinal.UP, 4).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.UP, 5).grow(Cardinal.directions, 9).fill(editor, rand, wall);
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 9).fill(editor, rand, this.theme.getPrimary().getFloor());
        CellSupport.generate(editor, rand, this.theme, origin);
        Cardinal.directions.forEach(dir -> {
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6));
            CellSupport.generate(editor, rand, this.theme, origin.copy().add((Cardinal)((Object)dir), 6).add(Cardinal.left(dir), 6));
        });
        for (Cardinal dir2 : Cardinal.directions) {
            BoundingBox.of(origin).add(dir2, 9).grow(Cardinal.orthogonal(dir2), 9).grow(Cardinal.UP, 4).fill(editor, rand, wall, Fill.SOLID);
            for (Cardinal o : Cardinal.orthogonal(dir2)) {
                BoundingBox.of(origin).add(dir2, 8).add(Cardinal.UP, 3).grow(o, 8).grow(Cardinal.UP, 2).fill(editor, rand, wall);
                BoundingBox.of(origin).add(dir2, 3).add(o, 2).add(Cardinal.UP, 3).grow(Cardinal.UP, 1).grow(dir2, 4).fill(editor, rand, wall);
                BoundingBox.of(origin).add(dir2, 7).add(o, 3).add(Cardinal.UP, 4).grow(o, 4).fill(editor, rand, wall);
                stair.setOrientation(Cardinal.reverse(dir2), true).fill(editor, rand, BoundingBox.of(origin).add(dir2, 7).add(o, 5).add(Cardinal.UP, 3).grow(o, 2));
                stair.set(editor, rand, origin.copy().add(dir2, 7).add(Cardinal.UP, 3).add(o, 3));
                wall.set(editor, rand, origin.copy().add(dir2, 7).add(Cardinal.UP, 3).add(o, 4));
                BoundingBox.of(origin).add(dir2, 8).add(o, 2).grow(Cardinal.UP, 2).fill(editor, rand, pillar);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add(dir2, 8).add(Cardinal.UP, 2).add(o));
                stair.setOrientation(Cardinal.reverse(dir2), true).set(editor, rand, origin.copy().add(dir2, 7).add(Cardinal.UP, 2).add(o, 2));
                stair.set(editor, rand, origin.copy().add(dir2, 8).add(Cardinal.UP, 2).add(o, 3));
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, origin.copy().add(dir2, 2).add(o).add(Cardinal.UP, 4));
            }
            BoundingBox.of(origin.copy()).add(dir2, 2).add(Cardinal.left(dir2), 2).grow(Cardinal.UP, 4).fill(editor, rand, pillar);
        }
        for (Cardinal dir2 : Cardinal.directions) {
            this.cornerPillars(editor, rand, origin.copy().add(dir2, 6).add(Cardinal.left(dir2), 6), Cardinal.left(dir2));
            BoundingBox.of(origin.copy()).add(dir2, 3).add(Cardinal.left(dir2), 3).add(Cardinal.DOWN).grow(dir2, 4).grow(Cardinal.left(dir2), 4).fill(editor, rand, this.theme.getSecondary().getFloor());
        }
        boolean table = true;
        for (Cardinal dir3 : Cardinal.randDirs(rand)) {
            if (table) {
                this.table(editor, rand, origin.copy().add(dir3, 6).add(Cardinal.left(dir3), 6), Cardinal.left(dir3));
            } else {
                this.chest(editor, rand, origin.copy().add(dir3, 6).add(Cardinal.left(dir3), 6), Cardinal.left(dir3));
            }
            table = !table;
        }
        this.generateExits(editor, rand);
    }

    private void chest(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getSecondary().getStair();
        stair.setOrientation(Cardinal.reverse(dir), false).fill(editor, rand, BoundingBox.of(origin).add(dir, 2).grow(Cardinal.orthogonal(dir)));
        stair.setOrientation(Cardinal.left(dir), false).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.right(dir), 2).grow(Cardinal.orthogonal(Cardinal.right(dir))));
        stair.setOrientation(dir, true).set(editor, rand, origin);
        stair.setOrientation(Cardinal.left(dir), true).set(editor, rand, origin.copy().add(Cardinal.left(dir)));
        stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, origin.copy().add(Cardinal.left(dir)).add(Cardinal.reverse(dir)));
        stair.setOrientation(Cardinal.right(dir), true).set(editor, rand, origin.copy().add(Cardinal.reverse(dir)));
        Candle.generate(editor, rand, origin.copy().add(Cardinal.reverse(dir)).add(Cardinal.left(dir)).add(Cardinal.UP));
    }

    private void table(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IStair stair = this.theme.getSecondary().getStair();
        stair.setOrientation(Cardinal.reverse(dir), true).fill(editor, rand, BoundingBox.of(origin).add(dir, 2).grow(Cardinal.orthogonal(dir)));
        stair.setOrientation(Cardinal.left(dir), true).fill(editor, rand, BoundingBox.of(origin).add(Cardinal.right(dir), 2).grow(Cardinal.orthogonal(Cardinal.right(dir))));
        Treasure.generate(editor, rand, this.settings.getDifficulty(), origin.copy().add(Cardinal.UP).add(dir, 2), Treasure.FOOD, ChestType.BARREL);
        Furnace.generate(editor, Cardinal.left(dir), origin.copy().add(Cardinal.UP).add(Cardinal.right(dir), 2), true, new class_1799((class_1935)class_1802.field_8713, rand.method_39332(1, 4)));
    }

    private void cornerPillars(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Pillar.generate(editor, rand, origin.copy().add(Cardinal.right(dir), 2).add(Cardinal.reverse(dir), 2), this.theme.getSecondary(), 2, Cardinal.directions);
        Pillar.generate(editor, rand, origin.copy().add(Cardinal.right(dir), 2).add(Cardinal.reverse(dir), 2).add(dir, 4), this.theme.getSecondary(), 2, Cardinal.directions);
        Pillar.generate(editor, rand, origin.copy().add(Cardinal.left(dir), 2).add(Cardinal.reverse(dir), 2).add(dir, 4), this.theme.getSecondary(), 2, Cardinal.directions);
    }

    @Override
    public String getName() {
        return Room.KITCHEN.name();
    }
}

