/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.cell.Cell;
import com.greymerk.roguelike.dungeon.cell.CellManager;
import com.greymerk.roguelike.dungeon.cell.CellState;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.room.AbstractLargeRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import net.minecraft.class_5819;

public class ReservoirRoom
extends AbstractLargeRoom
implements IRoom {
    @Override
    public void generate(IWorldEditor editor) {
        Coord origin = this.worldPos.copy().add(this.direction, 12);
        class_5819 rand = editor.getRandom(origin);
        this.clearUpper(editor, rand, origin);
        this.buildCells(editor, rand, origin);
        this.clearBasin(editor, rand, origin);
        this.basin(editor, rand, origin);
        this.ceiling(editor, rand, origin);
        this.addArches(editor, rand, origin);
        this.addLiquid(editor, rand, origin);
        this.generateExits(editor, rand);
    }

    private void clearBasin(IWorldEditor editor, class_5819 rand, Coord origin) {
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.add(Cardinal.DOWN, 2);
        bb.grow(Cardinal.directions, 10);
        bb.grow(Cardinal.DOWN, 5);
        RectSolid.fill(editor, rand, bb, Air.get());
    }

    private void clearUpper(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 10).grow(dir, 4);
            bb.grow(Cardinal.left(dir), 9);
            bb.grow(Cardinal.right(dir), 14);
            bb.grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, Air.get());
        }
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 10);
        bb.grow(Cardinal.UP, 4);
        bb.grow(Cardinal.DOWN);
        RectSolid.fill(editor, rand, bb, Air.get());
    }

    private void addLiquid(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory liquid = this.theme.getPrimary().getLiquid();
        BoundingBox bb = BoundingBox.of(origin);
        bb.add(Cardinal.DOWN, 5).grow(Cardinal.DOWN).grow(Cardinal.directions, 11);
        RectSolid.fill(editor, rand, bb, liquid, Fill.AIR);
    }

    private void ceiling(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin);
            bb.add(Cardinal.UP, 4).add(dir, 9).grow(dir).grow(Cardinal.left(dir), 8).grow(Cardinal.right(dir), 9);
            RectSolid.fill(editor, rand, bb, wall);
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                bb = BoundingBox.of(origin);
                bb.add(Cardinal.UP, 4).add(dir, 2).grow(o, 8);
                RectSolid.fill(editor, rand, bb, wall);
                Coord pos = origin.copy().add(Cardinal.UP, 3).add(dir, 2).add(o, 8);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
                pos.add(o);
                wall.set(editor, rand, pos);
                pos.add(Cardinal.DOWN);
                stair.set(editor, rand, pos);
                bb = BoundingBox.of(origin);
                bb.add(Cardinal.UP, 4).add(dir, 4).grow(o, 8);
                RectSolid.fill(editor, rand, bb, wall);
                pos = origin.copy().add(Cardinal.UP, 3).add(dir, 4).add(o, 8);
                stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
                pos.add(o);
                wall.set(editor, rand, pos);
                pos.add(Cardinal.DOWN);
                stair.set(editor, rand, pos);
                pos = origin.copy().add(Cardinal.UP, 3).add(o, 9).add(dir, 8);
                wall.set(editor, rand, pos);
                pos.add(Cardinal.DOWN);
                stair.set(editor, rand, pos);
            }
        }
    }

    private void buildCells(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 10).add(Cardinal.DOWN);
            bb.grow(dir, 3);
            bb.grow(Cardinal.left(dir), 13);
            bb.grow(Cardinal.right(dir), 9);
            RectSolid.fill(editor, rand, bb, this.theme.getPrimary().getFloor());
        }
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = origin.copy();
            pos.add(dir, 12);
            this.cell(editor, rand, pos.copy());
            pos.add(Cardinal.left(dir), 6);
            this.cell(editor, rand, pos.copy());
            pos.add(Cardinal.right(dir), 12);
            this.cell(editor, rand, pos.copy());
            pos.add(Cardinal.right(dir), 6);
            this.cell(editor, rand, pos.copy());
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 10).add(Cardinal.DOWN);
            bb.grow(Cardinal.orthogonal(dir), 14);
            RectSolid.fill(editor, rand, bb, wall, Fill.AIR);
            bb.add(dir, 4);
            RectSolid.fill(editor, rand, bb, wall, Fill.AIR);
            bb.add(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, wall, Fill.AIR);
            bb.add(Cardinal.reverse(dir), 2);
            RectSolid.fill(editor, rand, bb, wall, Fill.AIR);
        }
    }

    private void cell(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IBlockFactory pillar = this.theme.getPrimary().getPillar();
        IStair stair = this.theme.getPrimary().getStair();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin);
            bb.add(dir, 2).add(Cardinal.left(dir), 2).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, pillar);
            bb = BoundingBox.of(origin);
            bb.add(dir, 2).add(Cardinal.left(dir)).add(Cardinal.DOWN).grow(Cardinal.right(dir), 2);
            RectSolid.fill(editor, rand, bb, wall);
            bb.add(Cardinal.UP, 4);
            RectSolid.fill(editor, rand, bb, wall);
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord pos = origin.copy();
                pos.add(dir, 2);
                pos.add(o);
                pos.add(Cardinal.UP, 2);
                stair.setOrientation(Cardinal.reverse(o), true);
                stair.set(editor, rand, pos);
            }
        }
        CellSupport.generate(editor, rand, this.theme, origin.copy());
    }

    private void basin(IWorldEditor editor, class_5819 rand, Coord origin) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox bb = BoundingBox.of(origin.copy());
            bb.add(dir, 11).grow(dir, 2);
            bb.grow(Cardinal.left(dir), 10).grow(Cardinal.right(dir), 13);
            bb.add(Cardinal.DOWN).grow(Cardinal.DOWN, 8);
            RectSolid.fill(editor, rand, bb, wall);
        }
        BoundingBox bb = BoundingBox.of(origin.copy());
        bb.grow(Cardinal.directions, 13);
        bb.add(Cardinal.DOWN, 7).grow(Cardinal.DOWN, 3);
        RectSolid.fill(editor, rand, bb, wall);
        Coord pos = origin.copy();
        pos.add(Cardinal.DOWN, 9);
        CellSupport.generate(editor, rand, this.theme, pos.copy());
        for (Cardinal dir : Cardinal.directions) {
            pos = origin.copy().add(Cardinal.DOWN, 9).add(dir, 6);
            CellSupport.generate(editor, rand, this.theme, pos.copy());
            pos.add(Cardinal.left(dir), 6);
            CellSupport.generate(editor, rand, this.theme, pos.copy());
        }
    }

    private void addArches(IWorldEditor editor, class_5819 rand, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            Coord pos = origin.copy();
            pos.add(Cardinal.DOWN, 6);
            pos.add(dir, 10);
            this.largeArch(editor, rand, pos.copy(), dir);
            for (Cardinal o : Cardinal.orthogonal(dir)) {
                Coord p = pos.copy();
                p.add(o, 6);
                this.largeArch(editor, rand, p.copy(), dir);
            }
        }
    }

    private void largeArch(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        IBlockFactory wall = this.theme.getPrimary().getWall();
        IBlockFactory pillar = this.theme.getPrimary().getPillar();
        IStair stair = this.theme.getPrimary().getStair();
        BoundingBox bb = BoundingBox.of(origin);
        bb.grow(Cardinal.orthogonal(dir), 3).grow(dir).grow(Cardinal.UP, 4);
        RectSolid.fill(editor, rand, bb, Air.get());
        bb = BoundingBox.of(origin);
        bb.add(dir).add(Cardinal.UP, 4).grow(Cardinal.orthogonal(dir), 3);
        RectSolid.fill(editor, rand, bb, wall);
        Coord pos = origin.copy();
        pos.add(dir);
        pos.add(Cardinal.UP, 3);
        Lantern.set(editor, pos, Lantern.SOUL, true);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            bb = BoundingBox.of(origin);
            bb.add(o, 3).add(dir).grow(Cardinal.UP, 3);
            RectSolid.fill(editor, rand, bb, pillar);
            pos = origin.copy().add(o, 3).add(Cardinal.UP, 3);
            stair.setOrientation(Cardinal.reverse(dir), true).set(editor, rand, pos);
            pos.add(Cardinal.UP);
            wall.set(editor, rand, pos);
            pos.add(Cardinal.reverse(o));
            stair.setOrientation(Cardinal.reverse(o), true).set(editor, rand, pos);
            pos.add(dir).add(Cardinal.DOWN);
            stair.set(editor, rand, pos);
        }
    }

    @Override
    public CellManager getCells(Cardinal dir) {
        CellManager cells = new CellManager();
        Coord origin = Coord.ZERO;
        BoundingBox.of(origin).add(dir, 2).grow(Cardinal.directions, 2).forEach(pos -> cells.add(Cell.of(pos, CellState.OBSTRUCTED, this)));
        Cardinal.directions.forEach(d -> BoundingBox.of(origin).add((Cardinal)((Object)d), 3).grow(Cardinal.orthogonal(d), 2).forEach(pos -> {
            if (pos.equals(origin.add(Cardinal.reverse(dir), 3))) {
                return;
            }
            cells.add(Cell.of(pos, CellState.POTENTIAL, this));
        }));
        Coord lower = origin.add(Cardinal.DOWN).freeze();
        BoundingBox.of(lower).add(dir, 2).grow(Cardinal.directions).forEach(pos -> cells.add(Cell.of(pos, CellState.OBSTRUCTED, this)));
        for (Cardinal d2 : Cardinal.directions) {
            cells.add(Cell.of(lower.copy().add(dir, 2).add(d2, 2), CellState.OBSTRUCTED, this).addWall(d2));
            cells.add(Cell.of(lower.copy().add(dir, 2).add(d2, 2).add(Cardinal.left(d2), 2), CellState.OBSTRUCTED, this).addWall(d2).addWall(Cardinal.left(d2)));
            for (Cardinal o : Cardinal.orthogonal(d2)) {
                cells.add(Cell.of(lower.copy().add(dir, 2).add(d2, 2).add(o), CellState.OBSTRUCTED, this).addWall(d2));
            }
        }
        return cells;
    }

    @Override
    public BoundingBox getBoundingBox(Coord origin, Cardinal dir) {
        return super.getBoundingBox(origin, dir).grow(Cardinal.DOWN, 10);
    }

    @Override
    public String getName() {
        return Room.RESERVOIR.name();
    }
}

