/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.room;

import com.greymerk.roguelike.dungeon.layout.Exit;
import com.greymerk.roguelike.dungeon.room.AbyssRoom;
import com.greymerk.roguelike.dungeon.room.BTeamRoom;
import com.greymerk.roguelike.dungeon.room.BalconyRoom;
import com.greymerk.roguelike.dungeon.room.BanquetRoom;
import com.greymerk.roguelike.dungeon.room.BedRoom;
import com.greymerk.roguelike.dungeon.room.BrewingRoom;
import com.greymerk.roguelike.dungeon.room.CisternRoom;
import com.greymerk.roguelike.dungeon.room.Corridor;
import com.greymerk.roguelike.dungeon.room.CreeperRoom;
import com.greymerk.roguelike.dungeon.room.CrossRoom;
import com.greymerk.roguelike.dungeon.room.CryptRoom;
import com.greymerk.roguelike.dungeon.room.EnderRoom;
import com.greymerk.roguelike.dungeon.room.EntranceRoom;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.ImperialStairway;
import com.greymerk.roguelike.dungeon.room.KitchenRoom;
import com.greymerk.roguelike.dungeon.room.LibraryRoom;
import com.greymerk.roguelike.dungeon.room.MusicRoom;
import com.greymerk.roguelike.dungeon.room.OssuaryRoom;
import com.greymerk.roguelike.dungeon.room.PanopticonRoom;
import com.greymerk.roguelike.dungeon.room.PitRoom;
import com.greymerk.roguelike.dungeon.room.PrisonRoom;
import com.greymerk.roguelike.dungeon.room.ReservoirRoom;
import com.greymerk.roguelike.dungeon.room.SculkRoom;
import com.greymerk.roguelike.dungeon.room.SmithRoom;
import com.greymerk.roguelike.dungeon.room.Stairway;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Statistics;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.settings.LevelSettings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_5699;

public enum Room {
    CORRIDOR,
    ENTRANCE,
    STAIRWAY,
    CROSS,
    BEDROOM,
    CRYPT,
    RESERVOIR,
    CISTERN,
    OSSUARY,
    KITCHEN,
    CREEPER,
    ENDER,
    ABYSS,
    PRISON,
    MUSIC,
    BREWING,
    PANOPTICON,
    BANQUET,
    SCULK,
    BTEAM,
    LIBRARY,
    SMITH,
    PIT,
    BALCONY,
    IMPERIAL_STAIRWAY;

    public static final Codec<List<Exit>> EXITS_CODEC;
    public static final Codec<IRoom> CODEC;

    public static IRoom fromType(Room type) {
        switch (type.ordinal()) {
            case 0: {
                return new Corridor();
            }
            case 1: {
                return new EntranceRoom();
            }
            case 2: {
                return new Stairway();
            }
            case 3: {
                return new CrossRoom();
            }
            case 4: {
                return new BedRoom();
            }
            case 5: {
                return new CryptRoom();
            }
            case 6: {
                return new ReservoirRoom();
            }
            case 7: {
                return new CisternRoom();
            }
            case 8: {
                return new OssuaryRoom();
            }
            case 9: {
                return new KitchenRoom();
            }
            case 10: {
                return new CreeperRoom();
            }
            case 11: {
                return new EnderRoom();
            }
            case 12: {
                return new AbyssRoom();
            }
            case 13: {
                return new PrisonRoom();
            }
            case 14: {
                return new MusicRoom();
            }
            case 15: {
                return new BrewingRoom();
            }
            case 16: {
                return new PanopticonRoom();
            }
            case 17: {
                return new BanquetRoom();
            }
            case 18: {
                return new SculkRoom();
            }
            case 19: {
                return new BTeamRoom();
            }
            case 20: {
                return new LibraryRoom();
            }
            case 21: {
                return new SmithRoom();
            }
            case 22: {
                return new PitRoom();
            }
            case 23: {
                return new BalconyRoom();
            }
            case 24: {
                return new ImperialStairway();
            }
        }
        return new Corridor();
    }

    public static Room get(String name) {
        for (Room type : Room.values()) {
            if (!type.toString().equals(name)) continue;
            return type;
        }
        return CORRIDOR;
    }

    public static boolean contains(String name) {
        for (Room type : Room.values()) {
            if (!type.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, Coord floorPos, Coord worldPos) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        room.setFloorPos(floorPos);
        room.setWorldPos(worldPos);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, Coord floorPos, Coord worldPos, Cardinal dir) {
        IRoom room = Room.getInstance(type, settings, floorPos, worldPos);
        room.setDirection(dir);
        return room;
    }

    public static IRoom getInstance(Room type, ILevelSettings settings, Coord pos, Cardinal dir, List<Exit> exits, boolean generated, Statistics stats) {
        IRoom room = Room.fromType(type);
        room.setLevelSettings(settings);
        room.setWorldPos(pos);
        room.setDirection(dir);
        exits.forEach(e -> room.addExit((Exit)e));
        room.setGenerated(generated);
        room.mergeStats(stats);
        return room;
    }

    public static IRoom getInstance(String name, String settings, Coord pos, String dir, List<Exit> exits, boolean generated, Statistics stats) {
        return Room.getInstance(Room.get(name), LevelSettings.get(settings), pos, Cardinal.of(dir), exits, generated, stats);
    }

    static {
        EXITS_CODEC = Codec.list(Exit.CODEC);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(room -> room.getName()), (App)class_5699.field_41759.fieldOf("settings").forGetter(room -> room.getLevelSettings().getName()), (App)Coord.CODEC.fieldOf("pos").forGetter(room -> room.getWorldPos()), (App)class_5699.field_41759.fieldOf("dir").forGetter(room -> room.getDirection().name()), (App)EXITS_CODEC.fieldOf("exits").forGetter(room -> room.getExits()), (App)Codec.BOOL.fieldOf("generated").forGetter(room -> room.isGenerated()), (App)Statistics.CODEC.fieldOf("stats").forGetter(room -> room.getStats())).apply((Applicative)instance, (name, settings, pos, dir, exits, generated, stats) -> Room.getInstance(name, settings, pos, dir, (List<Exit>)exits, (boolean)generated, stats)));
    }
}

