/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.tower;

import com.greymerk.roguelike.dungeon.tower.ITower;
import com.greymerk.roguelike.dungeon.tower.RogueTower;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.theme.Theme;
import net.minecraft.class_5819;

public enum Tower {
    ROGUE;


    public static ITower get(Tower type) {
        switch (type.ordinal()) {
            case 0: {
                return new RogueTower();
            }
        }
        return new RogueTower();
    }

    public static Theme getDefaultTheme(Tower type) {
        return Theme.TOWER;
    }

    public static Coord getBaseCoord(IWorldEditor editor, Coord pos) {
        Coord cursor = editor.findSurface(pos);
        int yOffset = cursor.getY() - pos.getY();
        if (yOffset < 14) {
            yOffset = 14;
        }
        return pos.withY(pos.getY() + yOffset);
    }

    public static Tower get(String name) throws Exception {
        if (!Tower.contains(name.toUpperCase())) {
            throw new Exception("No such tower type: " + name);
        }
        return Tower.valueOf(name.toUpperCase());
    }

    public static boolean contains(String name) {
        for (Tower value : Tower.values()) {
            if (!value.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Tower getRandom(class_5819 rand) {
        return Tower.values()[rand.method_43048(Tower.values().length)];
    }
}

