/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor;

import com.greymerk.roguelike.util.math.RandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_5819;

public enum Cardinal {
    NORTH,
    EAST,
    WEST,
    SOUTH,
    UP,
    DOWN;

    public static final List<Cardinal> all;
    public static final List<Cardinal> directions;
    private static final List<String> names;
    private static final List<String> ordinalStrings;

    public static int index(Cardinal dir) {
        return Arrays.asList(Cardinal.values()).indexOf((Object)dir);
    }

    public static Cardinal of(String dir) {
        if (names.contains(dir)) {
            return Cardinal.valueOf(dir);
        }
        if (ordinalStrings.contains(dir)) {
            return all.get(Integer.parseInt(dir));
        }
        return NORTH;
    }

    public static Cardinal of(class_2350 direction) {
        switch (direction) {
            case field_11033: {
                return DOWN;
            }
            case field_11034: {
                return WEST;
            }
            case field_11043: {
                return SOUTH;
            }
            case field_11035: {
                return NORTH;
            }
            case field_11036: {
                return UP;
            }
            case field_11039: {
                return EAST;
            }
        }
        return null;
    }

    public static Cardinal get(String name) {
        switch (name) {
            case "NORTH": {
                return NORTH;
            }
            case "EAST": {
                return EAST;
            }
            case "WEST": {
                return WEST;
            }
            case "SOUTH": {
                return SOUTH;
            }
            case "UP": {
                return UP;
            }
            case "DOWN": {
                return DOWN;
            }
        }
        return NORTH;
    }

    public static Cardinal reverse(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return SOUTH;
            }
            case 1: {
                return WEST;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return NORTH;
            }
            case 5: {
                return UP;
            }
            case 4: {
                return DOWN;
            }
        }
        return null;
    }

    public static Cardinal left(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return WEST;
            }
            case 1: {
                return NORTH;
            }
            case 3: {
                return EAST;
            }
            case 2: {
                return SOUTH;
            }
        }
        return dir;
    }

    public static Cardinal right(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return EAST;
            }
            case 1: {
                return SOUTH;
            }
            case 3: {
                return WEST;
            }
            case 2: {
                return NORTH;
            }
        }
        return dir;
    }

    public static List<Cardinal> parallel(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return List.of(NORTH, SOUTH);
            }
            case 3: {
                return List.of(SOUTH, NORTH);
            }
            case 1: {
                return List.of(EAST, WEST);
            }
            case 2: {
                return List.of(WEST, EAST);
            }
        }
        return List.of(dir, dir);
    }

    public static List<Cardinal> orthogonal(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return List.of(WEST, EAST);
            }
            case 3: {
                return List.of(WEST, EAST);
            }
            case 1: {
                return List.of(NORTH, SOUTH);
            }
            case 2: {
                return List.of(NORTH, SOUTH);
            }
        }
        return List.of(dir, dir);
    }

    public static class_2350 facing(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return class_2350.field_11035;
            }
            case 1: {
                return class_2350.field_11039;
            }
            case 2: {
                return class_2350.field_11034;
            }
            case 3: {
                return class_2350.field_11043;
            }
            case 4: {
                return class_2350.field_11036;
            }
            case 5: {
                return class_2350.field_11033;
            }
        }
        return null;
    }

    public static class_2350.class_2351 axis(Cardinal dir) {
        switch (dir.ordinal()) {
            case 0: {
                return class_2350.class_2351.field_11051;
            }
            case 1: {
                return class_2350.class_2351.field_11048;
            }
            case 2: {
                return class_2350.class_2351.field_11048;
            }
            case 3: {
                return class_2350.class_2351.field_11051;
            }
            case 4: {
                return class_2350.class_2351.field_11052;
            }
            case 5: {
                return class_2350.class_2351.field_11052;
            }
        }
        return class_2350.class_2351.field_11052;
    }

    public static List<Cardinal> randDirs(class_5819 rand) {
        ArrayList<Cardinal> dirs = new ArrayList<Cardinal>(directions);
        RandHelper.shuffle(dirs, rand);
        return dirs;
    }

    static {
        all = Arrays.asList(NORTH, EAST, SOUTH, WEST, UP, DOWN);
        directions = Arrays.asList(NORTH, EAST, SOUTH, WEST);
        names = all.stream().map(dir -> dir.name()).collect(Collectors.toList());
        ordinalStrings = all.stream().map(dir -> Integer.toString(dir.ordinal())).collect(Collectors.toList());
    }
}

