/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor;

import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.IWorldInfo;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.Statistics;
import com.greymerk.roguelike.editor.WorldInfo;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;

public class WorldEditor
implements IWorldEditor {
    private class_1937 world;
    private class_5321<class_1937> worldKey;
    private IWorldInfo worldInfo;
    private Statistics stats;

    public static WorldEditor of(class_1937 world) {
        return new WorldEditor(world);
    }

    public static WorldEditor of(class_3218 world) {
        return new WorldEditor((class_1937)world);
    }

    @Deprecated
    public WorldEditor(class_5281 world, class_5321<class_1937> worldKey) {
    }

    private WorldEditor(class_1937 world) {
        this.world = world;
        this.worldKey = world.method_27983();
        this.worldInfo = WorldInfo.of(world, this.worldKey);
        this.stats = new Statistics();
    }

    @Override
    public boolean set(Coord pos, MetaBlock block, Predicate<BlockContext> p) {
        if (!p.and(Fill.IGNORE_BLOCK_ENTITIES).test(BlockContext.of(this, pos, block))) {
            return false;
        }
        return this.world.method_8652(pos.getBlockPos(), block.getState(), block.getFlag());
    }

    @Override
    public boolean set(Coord pos, MetaBlock block) {
        if (!Fill.IGNORE_BLOCK_ENTITIES.test(BlockContext.of(this, pos, block))) {
            return false;
        }
        return this.world.method_8652(pos.getBlockPos(), block.getState(), block.getFlag());
    }

    @Override
    public MetaBlock getBlock(Coord pos) {
        class_2680 state = this.world.method_8320(pos.getBlockPos());
        return MetaBlock.of(state);
    }

    @Override
    public boolean isAir(Coord pos) {
        return this.world.method_22347(pos.getBlockPos());
    }

    @Override
    public long getSeed(Coord pos) {
        return Objects.hash(this.worldInfo.getSeed(), pos.hashCode());
    }

    @Override
    public class_5819 getRandom(Coord pos) {
        if (!Config.ofBoolean(Config.DETERMINISTIC).booleanValue()) {
            long time = Date.from(Instant.now()).getTime();
            long seed = Objects.hash(time, pos);
            return new class_5820(seed);
        }
        return new class_5820(this.getSeed(pos));
    }

    @Override
    public boolean isChunkLoaded(Coord pos) {
        class_1923 cp = pos.getChunkPos();
        return this.world.method_8393(cp.field_9181, cp.field_9180);
    }

    @Override
    public boolean surroundingChunksLoaded(Coord pos) {
        class_1923 cpos = pos.getChunkPos();
        for (int x = cpos.field_9181 - 1; x <= cpos.field_9181 + 1; ++x) {
            for (int z = cpos.field_9180 - 1; z <= cpos.field_9180 + 1; ++z) {
                if (!this.world.method_8393(x, z)) {
                    return false;
                }
                class_2818 chunk = this.world.method_8497(x, z);
                class_2806 status = chunk.method_12009();
                if (status == class_2806.field_12803) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSolid(Coord pos) {
        return this.world.method_8320(pos.getBlockPos()).method_26212((class_1922)this.world, pos.getBlockPos());
    }

    @Override
    public boolean isSupported(Coord pos) {
        if (pos.getY() <= this.world.method_31607()) {
            return false;
        }
        Coord under = pos.copy().add(Cardinal.DOWN);
        class_2248 b = this.world.method_8320(under.getBlockPos()).method_26204();
        if (b instanceof class_2346) {
            return this.isSupported(under);
        }
        return !class_2346.method_10128((class_2680)this.world.method_8320(under.getBlockPos()));
    }

    @Override
    public boolean hasBlockEntity(Coord pos) {
        return this.world.method_8321(pos.getBlockPos()) != null;
    }

    private Optional<class_2586> getBlockEntity(Coord pos) {
        class_2586 be = this.world.method_8321(pos.getBlockPos());
        if (be == null) {
            return Optional.empty();
        }
        return Optional.of(be);
    }

    @Override
    public <T> Optional<T> getBlockEntity(Coord pos, Class<T> beClass) {
        Optional<class_2586> obe = this.getBlockEntity(pos);
        if (obe.isEmpty()) {
            return Optional.empty();
        }
        class_2586 be = obe.get();
        if (beClass.isInstance(be)) {
            return Optional.of(beClass.cast(be));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> setBlockEntity(Coord pos, MetaBlock block, Class<T> beClass) {
        if (!this.set(pos, block)) {
            return Optional.empty();
        }
        return this.getBlockEntity(pos, beClass);
    }

    @Override
    public boolean isFaceFullSquare(Coord pos, Cardinal dir) {
        class_2680 b = this.world.method_8320(pos.getBlockPos());
        class_2350 facing = Cardinal.facing(dir);
        class_265 shape = b.method_26222((class_1922)this.world, pos.getBlockPos());
        class_265 collision = b.method_26220((class_1922)this.world, pos.getBlockPos());
        boolean isShapeSquare = class_2248.method_9501((class_265)shape, (class_2350)facing);
        boolean isCollisionSquare = class_2248.method_9501((class_265)collision, (class_2350)facing);
        return isShapeSquare || isCollisionSquare;
    }

    @Override
    public Coord findSurface(Coord pos) {
        Coord cursor = pos.withY(this.world.method_31600());
        int seaLevel = this.worldInfo.getSeaLevel();
        while (cursor.getY() > seaLevel - 3) {
            MetaBlock m = this.getBlock(cursor);
            if (m.isIn(List.of(class_3481.field_15475, class_3481.field_15503))) {
                cursor.add(Cardinal.DOWN);
                continue;
            }
            if (!this.world.method_22347(cursor.getBlockPos()) && !m.isPlant()) {
                return cursor;
            }
            cursor.add(Cardinal.DOWN);
        }
        return cursor;
    }

    @Override
    public int getDungeonEntryDepth(Coord origin) {
        Coord surface = this.findSurface(origin);
        return surface.getY() - Math.floorMod(surface.getY(), 10) - 10;
    }

    @Override
    public class_5321<class_1937> getRegistryKey() {
        return this.worldKey;
    }

    @Override
    public IWorldInfo getInfo() {
        return this.worldInfo;
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }

    @Override
    public void clearStats() {
        this.stats = new Statistics();
    }
}

