/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldInfo;
import com.greymerk.roguelike.state.RoguelikeState;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6874;
import net.minecraft.class_7059;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class WorldInfo
implements IWorldInfo {
    private class_1937 world;
    class_5321<class_1937> worldKey;

    public static WorldInfo of(class_1937 world, class_5321<class_1937> worldKey) {
        return new WorldInfo(world, worldKey);
    }

    private WorldInfo(class_1937 world, class_5321<class_1937> worldKey) {
        this.world = world;
        this.worldKey = worldKey;
    }

    @Override
    public int getSeaLevel() {
        if (this.isFlat()) {
            return 64;
        }
        return this.world.method_8615();
    }

    @Override
    public int getTopYInclusive() {
        return this.world.method_31600();
    }

    @Override
    public int getBottomY() {
        return this.world.method_31607();
    }

    @Override
    public boolean isOverworld() {
        MinecraftServer mcServer = this.world.method_8503();
        class_3218 sw = mcServer.method_3847(this.worldKey);
        return sw.method_40134().method_40225(class_7134.field_37666);
    }

    @Override
    public class_5455 getRegistryManager() {
        return this.world.method_30349();
    }

    @Override
    public class_7699 getFeatureSet() {
        return this.world.method_45162();
    }

    @Override
    public Path getWorldDirectory() {
        return this.world.method_8503().method_27050(class_5218.field_24188);
    }

    @Override
    public class_1928 getGameRules() {
        return this.world.method_8503().method_3767();
    }

    @Override
    public class_5321<class_1937> getRegistryKey() {
        return this.worldKey;
    }

    @Override
    public RoguelikeState getState() {
        return RoguelikeState.getServerState(this.worldKey, this.world.method_8503());
    }

    @Override
    public long getSeed() {
        MinecraftServer server = this.world.method_8503();
        class_3218 sw = server.method_30002();
        return sw.method_8412();
    }

    @Override
    public Optional<Coord> getStructureLocation(class_5321<class_7059> key, class_1923 cpos) {
        MinecraftServer mcServer = this.world.method_8503();
        class_3218 sw = mcServer.method_3847(this.worldKey);
        class_7869 calculator = sw.method_14178().method_46642();
        class_5455 reg = this.world.method_30349();
        class_2378 structures = reg.method_30530(class_7924.field_41248);
        class_7059 structure = (class_7059)structures.method_29107(key);
        class_6874 placement = structure.comp_511();
        if (!placement.method_41639(calculator, cpos.field_9181, cpos.field_9180)) {
            return Optional.empty();
        }
        return Optional.of(Coord.of(placement.method_41636(cpos)));
    }

    @Override
    public int getLastFloorDepth() {
        int minY = this.getBottomY();
        return minY - Math.floorMod(minY, 10) + 20;
    }

    @Override
    public int getFirstFloorDepth() {
        int sl = this.getSeaLevel();
        return sl - Math.floorMod(sl, 10) - 10;
    }

    public boolean isFlat() {
        return this.world.method_8503().method_30002().method_28125();
    }
}

