/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.factories.BlockCheckers;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.util.Color;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_5819;

public class Carpet {
    public static void generate(IWorldEditor editor, class_5819 rand, Coord origin, int radius) {
        List<Color> colors = Arrays.asList(Color.values());
        RandHelper.shuffle(colors, rand);
        BoundingBox bb = BoundingBox.of(origin).grow(Cardinal.directions, radius);
        RectSolid.fill(editor, rand, bb, Carpet.get(colors.get(0)));
        if (radius < 3) {
            return;
        }
        BlockCheckers checkers = new BlockCheckers(Carpet.get(colors.get(1)), Carpet.get(colors.get(2)));
        bb = BoundingBox.of(origin).grow(Cardinal.directions, radius - 1);
        RectSolid.fill(editor, rand, bb, checkers);
        bb = BoundingBox.of(origin).grow(Cardinal.directions);
        RectSolid.fill(editor, rand, bb, Carpet.get(colors.get(3)));
    }

    public static MetaBlock getRandom(class_5819 rand) {
        return Carpet.get(Color.get(rand));
    }

    public static MetaBlock get(Color color) {
        return MetaBlock.of(Carpet.fromColor(color));
    }

    private static class_2248 fromColor(Color color) {
        switch (color) {
            case BLACK: {
                return class_2246.field_10106;
            }
            case BLUE: {
                return class_2246.field_10043;
            }
            case BROWN: {
                return class_2246.field_10473;
            }
            case CYAN: {
                return class_2246.field_10433;
            }
            case GRAY: {
                return class_2246.field_10591;
            }
            case GREEN: {
                return class_2246.field_10338;
            }
            case LIGHT_BLUE: {
                return class_2246.field_10290;
            }
            case LIGHT_GRAY: {
                return class_2246.field_10209;
            }
            case LIME: {
                return class_2246.field_10040;
            }
            case MAGENTA: {
                return class_2246.field_10482;
            }
            case ORANGE: {
                return class_2246.field_9977;
            }
            case PINK: {
                return class_2246.field_10393;
            }
            case PURPLE: {
                return class_2246.field_10510;
            }
            case RED: {
                return class_2246.field_10536;
            }
            case WHITE: {
                return class_2246.field_10466;
            }
            case YELLOW: {
                return class_2246.field_10512;
            }
        }
        return class_2246.field_10106;
    }
}

