/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_7130;

public class SculkVein {
    public static boolean set(IWorldEditor editor, Coord origin) {
        if (!SculkVein.canPlace(editor, origin)) {
            return false;
        }
        MetaBlock vein = MetaBlock.of(class_2246.field_37569);
        SculkVein.setSides(editor, origin, vein);
        vein.set(editor, origin);
        return true;
    }

    public static boolean canPlace(IWorldEditor editor, Coord origin) {
        if (!editor.isAir(origin)) {
            return false;
        }
        for (Cardinal dir : Cardinal.all) {
            if (!editor.isFaceFullSquare(origin.copy().add(dir).freeze(), Cardinal.reverse(dir))) continue;
            return true;
        }
        return false;
    }

    public static void setSides(IWorldEditor editor, Coord origin, MetaBlock vein) {
        Cardinal.all.forEach(dir -> {
            if (!editor.isFaceFullSquare(origin.copy().add((Cardinal)((Object)dir)), (Cardinal)((Object)dir))) {
                return;
            }
            SculkVein.setFace(editor, origin, vein, dir);
        });
    }

    private static void setFace(IWorldEditor editor, Coord origin, MetaBlock vein, Cardinal dir) {
        class_2350 facing = Cardinal.directions.contains((Object)dir) ? Cardinal.facing(Cardinal.reverse(dir)) : Cardinal.facing(dir);
        vein.with(class_7130.method_33374((class_2350)facing), true);
    }
}

