/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2484;
import net.minecraft.class_5819;

public enum Skull {
    SKELETON,
    WITHER,
    ZOMBIE,
    STEVE,
    CREEPER;


    public static void set(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir) {
        Skull type = rand.method_43048(10) == 0 ? WITHER : SKELETON;
        Skull.set(editor, rand, origin, dir, type);
    }

    public static void set(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir, Skull type) {
        Skull.setRotation(rand, MetaBlock.of(Skull.fromType(type)), dir).set(editor, origin, Fill.SUPPORTED);
    }

    public static MetaBlock setRotation(class_5819 rand, MetaBlock skull, Cardinal dir) {
        int directionValue = Skull.getDirectionValue(dir);
        directionValue += -1 + rand.method_43048(3);
        directionValue = Math.floorMod(directionValue, 16);
        skull.with(class_2484.field_11505, directionValue);
        return skull;
    }

    public static class_2248 fromType(Skull type) {
        switch (type.ordinal()) {
            case 0: {
                return class_2246.field_10481;
            }
            case 1: {
                return class_2246.field_10177;
            }
            case 2: {
                return class_2246.field_10241;
            }
            case 3: {
                return class_2246.field_10432;
            }
            case 4: {
                return class_2246.field_10042;
            }
        }
        return class_2246.field_10481;
    }

    public static int getDirectionValue(Cardinal dir) {
        switch (dir) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 8;
            }
            case WEST: {
                return 12;
            }
        }
        return 0;
    }
}

