/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.shapes.IShape;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_2746;
import net.minecraft.class_5819;

public class Vine {
    public static void fill(IWorldEditor editor, class_5819 rand, IShape toFill) {
        toFill.forEach(c -> Vine.set(editor, c));
    }

    public static void set(IWorldEditor editor, Coord origin) {
        if (!Vine.canPlace(editor, origin)) {
            return;
        }
        Vine.setSides(editor, origin);
    }

    public static boolean canPlace(IWorldEditor editor, Coord origin) {
        if (!editor.isAir(origin)) {
            return false;
        }
        for (Cardinal dir : Cardinal.directions) {
            if (!editor.isFaceFullSquare(origin.copy().add(dir), Cardinal.reverse(dir))) continue;
            return true;
        }
        return false;
    }

    public static void setSides(IWorldEditor editor, Coord origin) {
        for (Cardinal dir : Cardinal.values()) {
            if (dir == Cardinal.DOWN) {
                return;
            }
            Vine.setFace(editor, origin, Cardinal.reverse(dir));
        }
    }

    public static void setFace(IWorldEditor editor, Coord origin, Cardinal dir) {
        Coord pos = origin.copy().add(dir);
        if (!editor.isFaceFullSquare(pos, dir)) {
            return;
        }
        class_2350 facing = Cardinal.directions.contains((Object)dir) ? Cardinal.facing(Cardinal.reverse(dir)) : Cardinal.facing(dir);
        class_2746 facingProperty = class_2541.method_10828((class_2350)facing);
        if (facingProperty == null) {
            return;
        }
        MetaBlock.of(class_2246.field_10597).with(facingProperty, true).set(editor, origin.copy());
    }
}

