/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks.spawners;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.spawners.Spawnable;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5819;

public class SpawnerSettings {
    private Map<Spawner, WeightedRandomizer<Spawnable>> spawners = new HashMap<Spawner, WeightedRandomizer<Spawnable>>();

    public SpawnerSettings() {
    }

    public SpawnerSettings(SpawnerSettings toCopy) {
        this();
        for (Spawner type : toCopy.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(toCopy.spawners.get((Object)type));
        }
    }

    public SpawnerSettings(SpawnerSettings base, SpawnerSettings other) {
        this();
        for (Spawner type : base.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(base.spawners.get((Object)type));
        }
        for (Spawner type : other.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(other.spawners.get((Object)type));
        }
    }

    public void generate(IWorldEditor editor, class_5819 rand, Coord cursor, Spawner type, Difficulty diff) {
        Spawnable toSpawn = this.spawners.containsKey((Object)type) ? this.spawners.get((Object)type).get(rand) : new Spawnable(type);
        toSpawn.generate(editor, rand, cursor, diff);
    }

    public String toString() {
        return this.spawners.keySet().toString();
    }
}

