/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.boundingbox;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.IShape;
import com.greymerk.roguelike.editor.shapes.Shape;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2818;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class BoundingBox
implements IBounded,
IShape,
Iterable<Coord> {
    public static Codec<BoundingBox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Coord.CODEC.fieldOf("start").forGetter(bb -> bb.start), (App)Coord.CODEC.fieldOf("end").forGetter(bb -> bb.end)).apply((Applicative)instance, BoundingBox::new));
    private Coord start;
    private Coord end;

    public static BoundingBox of(Coord origin) {
        return new BoundingBox(origin);
    }

    public static BoundingBox of(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        return BoundingBox.of(Coord.of(cpos.method_8326(), chunk.method_31607(), cpos.method_8328()), Coord.of(cpos.method_8327(), chunk.method_31600(), cpos.method_8329()));
    }

    public static BoundingBox of(Coord start, Coord end) {
        return new BoundingBox(start, end);
    }

    public static BoundingBox of(IBounded box) {
        return new BoundingBox(box.getStart(), box.getEnd());
    }

    public BoundingBox copy() {
        return new BoundingBox(this.start, this.end);
    }

    private BoundingBox(Coord origin) {
        this.start = origin.copy();
        this.end = origin.copy();
    }

    private BoundingBox(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
        this.correct();
    }

    public BoundingBox(class_2487 tag) {
        this.start = Coord.of((class_2487)tag.method_10562("start").get());
        this.end = Coord.of((class_2487)tag.method_10562("end").get());
        this.correct();
    }

    public BoundingBox getBoundingBox() {
        return this;
    }

    public BoundingBox combine(IBounded other) {
        BoundingBox starts = new BoundingBox(this.start, other.getStart());
        BoundingBox ends = new BoundingBox(this.end, other.getEnd());
        this.start = starts.start;
        this.end = ends.end;
        this.correct();
        return this;
    }

    @Override
    public boolean collide(IBounded other) {
        BoundingBox otherBox = BoundingBox.of(other);
        if (this.end.getX() < otherBox.start.getX() || otherBox.end.getX() < this.start.getX()) {
            return false;
        }
        if (this.end.getY() < otherBox.start.getY() || otherBox.end.getY() < this.start.getY()) {
            return false;
        }
        return this.end.getZ() >= otherBox.start.getZ() && otherBox.end.getZ() >= this.start.getZ();
    }

    @Override
    public IShape getShape(Shape type) {
        return Shape.get(type, this);
    }

    public BoundingBox grow(Cardinal dir) {
        return this.grow(dir, 1);
    }

    public BoundingBox grow(Cardinal dir, int amount) {
        switch (dir) {
            case DOWN: 
            case NORTH: 
            case WEST: {
                this.start.add(dir, amount);
                break;
            }
            case UP: 
            case EAST: 
            case SOUTH: {
                this.end.add(dir, amount);
                break;
            }
        }
        this.correct();
        return this;
    }

    public BoundingBox grow(Iterable<Cardinal> dirs) {
        return this.grow(dirs, 1);
    }

    public BoundingBox grow(Iterable<Cardinal> dirs, int amount) {
        for (Cardinal dir : dirs) {
            this.grow(dir, amount);
        }
        return this;
    }

    public BoundingBox add(Cardinal dir) {
        return this.add(dir, 1);
    }

    public BoundingBox add(Cardinal dir, int amount) {
        this.start.add(dir, amount);
        this.end.add(dir, amount);
        return this;
    }

    public BoundingBox add(Coord pos) {
        this.start.add(pos);
        this.end.add(pos);
        return this;
    }

    @Override
    public Coord getStart() {
        return this.start.copy();
    }

    @Override
    public Coord getEnd() {
        return this.end.copy();
    }

    @Override
    public boolean contains(Coord pos) {
        if (pos.getX() < this.start.getX() || pos.getX() > this.end.getX()) {
            return false;
        }
        if (pos.getY() < this.start.getY() || pos.getY() > this.end.getY()) {
            return false;
        }
        return pos.getZ() >= this.start.getZ() && pos.getZ() <= this.end.getZ();
    }

    public int hashCode() {
        return Objects.hash(this.end, this.start);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        return Objects.equals(this.end, other.end) && Objects.equals(this.start, other.start);
    }

    private void correct() {
        Coord s = Coord.of(this.end.getX() < this.start.getX() ? this.end.getX() : this.start.getX(), this.end.getY() < this.start.getY() ? this.end.getY() : this.start.getY(), this.end.getZ() < this.start.getZ() ? this.end.getZ() : this.start.getZ());
        Coord e = Coord.of(this.end.getX() < this.start.getX() ? this.start.getX() : this.end.getX(), this.end.getY() < this.start.getY() ? this.start.getY() : this.end.getY(), this.end.getZ() < this.start.getZ() ? this.start.getZ() : this.end.getZ());
        this.start = s;
        this.end = e;
    }

    @Override
    public Iterator<Coord> iterator() {
        return this.getShape(Shape.RECTSOLID).iterator();
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, @NotNull IBlockFactory block) {
        this.getShape(Shape.RECTSOLID).fill(editor, rand, block);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, @NotNull IBlockFactory block, Predicate<BlockContext> p) {
        this.getShape(Shape.RECTSOLID).fill(editor, rand, block, p);
    }

    @Override
    public List<Coord> get() {
        return this.getShape(Shape.RECTSOLID).get();
    }

    public String toString() {
        return List.of(this.start, this.end).toString();
    }

    public Stream<Coord> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

