/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.factories;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.factories.BlockBase;
import java.util.function.Predicate;
import net.minecraft.class_5819;

public class BlockCheckers
extends BlockBase {
    private IBlockFactory fillOne;
    private IBlockFactory fillTwo;
    private Coord offset;

    public static BlockCheckers of(IBlockFactory fillOne, IBlockFactory fillTwo) {
        return new BlockCheckers(fillOne, fillTwo);
    }

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo, Coord offset) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
        this.offset = offset.copy();
    }

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo) {
        this(fillOne, fillTwo, Coord.ZERO);
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord origin, Predicate<BlockContext> p) {
        int x = origin.getX() - this.offset.getX();
        int y = origin.getY() - this.offset.getY();
        int z = origin.getZ() - this.offset.getY();
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    return this.fillOne.set(editor, rand, origin.copy(), p);
                }
                return this.fillTwo.set(editor, rand, origin.copy(), p);
            }
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, origin.copy(), p);
            }
            return this.fillOne.set(editor, rand, origin.copy(), p);
        }
        if (z % 2 == 0) {
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, origin.copy(), p);
            }
            return this.fillOne.set(editor, rand, origin.copy(), p);
        }
        if (y % 2 == 0) {
            return this.fillOne.set(editor, rand, origin.copy(), p);
        }
        return this.fillTwo.set(editor, rand, origin.copy(), p);
    }
}

