/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.factories;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.factories.BlockBase;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import java.util.function.Predicate;
import net.minecraft.class_5819;

public class BlockFloor
extends BlockBase
implements IBlockFactory {
    private IBlockFactory floor;
    private IBlockFactory bridge;

    public static BlockFloor of(IBlockFactory floor) {
        return new BlockFloor(floor);
    }

    public BlockFloor(IBlockFactory floor) {
        this.floor = floor;
        BlockWeightedRandom bridge = new BlockWeightedRandom();
        bridge.add(floor, 10);
        bridge.add(Air.get(), 1);
        this.bridge = bridge;
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos, Predicate<BlockContext> p) {
        return this.floor.set(editor, rand, pos, Fill.SOLID.and(p)) || this.bridge.set(editor, rand, pos, Fill.AIR.and(p));
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos) {
        return this.floor.set(editor, rand, pos, Fill.SOLID) || this.bridge.set(editor, rand, pos, Fill.AIR);
    }
}

