/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class Column
implements IShape {
    private Coord top;

    public Column(Coord top) {
        this.top = top.copy();
    }

    public static void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks, Coord top) {
        new Column(top).fillDown(editor, rand, blocks);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.forEach(c -> block.set(editor, rand, this.top, Fill.ALWAYS));
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        this.forEach(c -> block.set(editor, rand, this.top, p));
    }

    public List<Coord> getUntilSolid(IWorldEditor editor) {
        FillDownIterator itr = new FillDownIterator(this, editor, this.top.copy());
        ArrayList<Coord> cl = new ArrayList<Coord>();
        itr.forEachRemaining(c -> cl.add((Coord)c));
        return cl;
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    public void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks) {
        this.fillDown(editor, rand, blocks, Fill.ALWAYS);
    }

    public void fillDown(IWorldEditor editor, class_5819 rand, IBlockFactory blocks, Predicate<BlockContext> p) {
        FillDownIterator itr = new FillDownIterator(this, editor, this.top.copy());
        itr.forEachRemaining(c -> blocks.set(editor, rand, (Coord)c, p));
    }

    @Override
    public Iterator<Coord> iterator() {
        return new ColumnIterator(this, this.top.copy());
    }

    private class FillDownIterator
    extends ColumnIterator {
        private IWorldEditor editor;

        public FillDownIterator(Column column, IWorldEditor editor, Coord origin) {
            super(column, origin);
            this.editor = editor;
        }

        @Override
        public boolean hasNext() {
            if (this.editor.isSolid(this.current)) {
                return false;
            }
            return this.current.getY() > this.editor.getInfo().getBottomY();
        }
    }

    private class ColumnIterator
    implements Iterator<Coord> {
        static final int MAX_DEPTH = -62;
        Coord current;

        public ColumnIterator(Column column, Coord origin) {
            this.current = origin.copy();
        }

        @Override
        public boolean hasNext() {
            return this.current.getY() > -62;
        }

        @Override
        public Coord next() {
            Coord last = this.current.copy();
            this.current.add(Cardinal.DOWN);
            return last;
        }
    }
}

