/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class Ellipsoid
implements IShape {
    private Coord start;
    private Coord end;

    public Ellipsoid(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new EllipsoidIterator(this, this.start, this.end);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, Fill.ALWAYS);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, p);
        }
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    private class EllipsoidIterator
    implements Iterator<Coord> {
        private Coord centre;
        private Coord diff;
        private Coord cursor;
        private Cardinal dir;
        private boolean top;

        public EllipsoidIterator(Ellipsoid ellipsoid, Coord centre, Coord end) {
            this.centre = centre.copy();
            Coord s = centre.copy();
            Coord e = end.copy();
            this.diff = e.sub(s);
            this.diff = Coord.of(Math.abs(this.diff.getX()), Math.abs(this.diff.getY()), Math.abs(this.diff.getZ()));
            this.cursor = Coord.ZERO;
            this.top = true;
            this.dir = Cardinal.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.centre.copy();
            toReturn.add(this.top ? Cardinal.UP : Cardinal.DOWN, this.cursor.getY());
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                toReturn.add(Cardinal.left(this.dir), this.cursor.getX());
                toReturn.add(this.dir, this.cursor.getZ());
            } else {
                toReturn.add(this.dir, this.cursor.getX());
                toReturn.add(Cardinal.left(this.dir), this.cursor.getZ());
            }
            if (this.dir != Cardinal.NORTH || this.top) {
                if (this.dir == Cardinal.NORTH) {
                    this.top = false;
                }
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor.add(Cardinal.SOUTH);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.cursor = Coord.of(this.cursor.getX(), this.cursor.getY(), 0);
            this.cursor.add(Cardinal.EAST);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.cursor = Coord.of(0, this.cursor.getY(), this.cursor.getZ());
            this.cursor.add(Cardinal.UP);
            this.dir = Cardinal.left(this.dir);
            this.top = true;
            return toReturn;
        }

        private boolean inRange(Coord pos) {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            double rx = this.diff.getX() == 0 ? 1.0 : (double)this.diff.getX();
            double ry = this.diff.getY() == 0 ? 1.0 : (double)this.diff.getY();
            double rz = this.diff.getZ() == 0 ? 1.0 : (double)this.diff.getZ();
            return x / rx * (x / rx) + y / ry * (y / ry) + z / rz * (z / rz) <= 1.0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

