/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class Line
implements IShape {
    Coord start;
    Coord end;

    public static Line of(Coord start, Coord end) {
        return new Line(start, end);
    }

    public Line(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, Fill.ALWAYS);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        for (Coord c : this) {
            block.set(editor, rand, c, p);
        }
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new LineIterator(this);
    }

    private class LineIterator
    implements Iterator<Coord> {
        int x;
        int y;
        int z;
        int dx;
        int dy;
        int dz;
        int l;
        int m;
        int n;
        int x_inc;
        int y_inc;
        int z_inc;
        int err_1;
        int err_2;
        int dx2;
        int dy2;
        int dz2;
        int counter;
        Coord current;

        public LineIterator(Line line) {
            this.current = line.start.copy();
            this.x = line.start.getX();
            this.y = line.start.getY();
            this.z = line.start.getZ();
            this.dx = line.end.getX() - line.start.getX();
            this.dy = line.end.getY() - line.start.getY();
            this.dz = line.end.getZ() - line.start.getZ();
            this.x_inc = this.dx < 0 ? -1 : 1;
            this.y_inc = this.dy < 0 ? -1 : 1;
            this.z_inc = this.dz < 0 ? -1 : 1;
            this.l = Math.abs(this.dx);
            this.m = Math.abs(this.dy);
            this.n = Math.abs(this.dz);
            this.dx2 = this.l << 1;
            this.dy2 = this.m << 1;
            this.dz2 = this.n << 1;
            this.counter = 0;
            if (this.l >= this.m && this.l >= this.n) {
                this.err_1 = this.dy2 - this.l;
                this.err_2 = this.dz2 - this.l;
            } else if (this.m >= this.l && this.m >= this.n) {
                this.err_1 = this.dx2 - this.m;
                this.err_2 = this.dz2 - this.m;
            } else {
                this.err_1 = this.dy2 - this.n;
                this.err_2 = this.dx2 - this.n;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.l >= this.m && this.l >= this.n) {
                return this.counter <= this.l;
            }
            if (this.m >= this.l && this.m >= this.n) {
                return this.counter <= this.m;
            }
            return this.counter <= this.n;
        }

        @Override
        public Coord next() {
            if (this.l > this.m && this.l > this.n) {
                if (this.err_1 > 0) {
                    this.y += this.y_inc;
                    this.err_1 -= this.dx2;
                }
                if (this.err_2 > 0) {
                    this.z += this.z_inc;
                    this.err_2 -= this.dx2;
                }
                this.err_1 += this.dy2;
                this.err_2 += this.dz2;
                this.x += this.x_inc;
            } else if (this.m > this.l && this.m > this.n) {
                if (this.err_1 > 0) {
                    this.x += this.x_inc;
                    this.err_1 -= this.dy2;
                }
                if (this.err_2 > 0) {
                    this.z += this.z_inc;
                    this.err_2 -= this.dy2;
                }
                this.err_1 += this.dx2;
                this.err_2 += this.dz2;
                this.y += this.y_inc;
            } else {
                if (this.err_1 > 0) {
                    this.y += this.y_inc;
                    this.err_1 -= this.dz2;
                }
                if (this.err_2 > 0) {
                    this.x += this.x_inc;
                    this.err_2 -= this.dz2;
                }
                this.err_1 += this.dy2;
                this.err_2 += this.dx2;
                this.z += this.z_inc;
            }
            ++this.counter;
            Coord toReturn = this.current.copy();
            this.current = Coord.of(this.x, this.y, this.z);
            return toReturn;
        }
    }
}

