/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class RectPyramid
implements IShape {
    private BoundingBox bb;

    public RectPyramid(BoundingBox bb) {
        this.bb = bb;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new SquarePyramidIterator(this, this.bb);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, Fill.ALWAYS);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, p);
        }
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    private class SquarePyramidIterator
    implements Iterator<Coord> {
        Coord start;
        Coord diff;
        Coord cursor;
        Cardinal dir;
        double thetaX;
        double thetaZ;

        public SquarePyramidIterator(RectPyramid rectPyramid, BoundingBox bb) {
            this.start = bb.getStart();
            Coord s = bb.getStart();
            Coord e = bb.getEnd();
            this.cursor = Coord.ZERO;
            this.dir = Cardinal.NORTH;
            this.diff = e.copy();
            this.diff.sub(s);
            double hx = Math.sqrt(Math.pow(this.diff.getX(), 2.0) + Math.pow(this.diff.getY(), 2.0));
            this.thetaX = Math.acos((double)this.diff.getY() / hx);
            double hz = Math.sqrt(Math.pow(this.diff.getZ(), 2.0) + Math.pow(this.diff.getY(), 2.0));
            this.thetaZ = Math.acos((double)this.diff.getY() / hz);
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.start.copy();
            toReturn.add(Cardinal.UP, this.cursor.getY());
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                toReturn.add(Cardinal.left(this.dir), this.cursor.getX());
                toReturn.add(this.dir, this.cursor.getZ());
            } else {
                toReturn.add(this.dir, this.cursor.getX());
                toReturn.add(Cardinal.left(this.dir), this.cursor.getZ());
            }
            if (this.dir != Cardinal.NORTH) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor.add(Cardinal.SOUTH);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor = this.cursor.withZ(0);
            this.cursor.add(Cardinal.EAST);
            if (this.inRange(this.cursor)) {
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            this.cursor = this.cursor.withX(0);
            this.cursor.add(Cardinal.UP);
            this.dir = Cardinal.left(this.dir);
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean inRange(Coord pos) {
            int y = this.diff.getY() - this.cursor.getY();
            if (!((double)this.cursor.getX() < Math.tan(this.thetaX) * (double)y)) {
                return false;
            }
            return (double)this.cursor.getZ() < Math.tan(this.thetaZ) * (double)y;
        }
    }
}

