/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class RectSolid
implements IShape {
    private BoundingBox bb;

    public RectSolid(IBounded box) {
        this.bb = BoundingBox.of(box);
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded box, IBlockFactory blocks) {
        new RectSolid(BoundingBox.of(box)).fill(editor, rand, blocks, Fill.ALWAYS);
    }

    public static void fill(IWorldEditor editor, class_5819 rand, IBounded box, IBlockFactory blocks, Predicate<BlockContext> p) {
        new RectSolid(BoundingBox.of(box)).fill(editor, rand, blocks, p);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.forEach(c -> block.set(editor, rand, (Coord)c));
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        this.forEach(c -> block.set(editor, rand, (Coord)c, p));
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectSolidIterator(this, this.bb);
    }

    private class RectSolidIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord start;
        Coord end;

        public RectSolidIterator(RectSolid rectSolid, BoundingBox bb) {
            this.start = bb.getStart();
            this.end = bb.getEnd();
            this.cursor = this.start.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.end.getY();
        }

        @Override
        public Coord next() {
            Coord current = this.cursor.copy();
            if (this.cursor.getZ() == this.end.getZ() && this.cursor.getX() == this.end.getX()) {
                this.cursor = this.start.withY(this.cursor.getY()).add(Cardinal.UP);
                return current;
            }
            if (this.cursor.getX() == this.end.getX()) {
                this.cursor = this.cursor.withX(this.start.getX()).add(Cardinal.SOUTH);
                return current;
            }
            this.cursor.add(Cardinal.EAST);
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

