/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class RectWireframe
implements IShape {
    private BoundingBox bb;

    private RectWireframe(BoundingBox bb) {
        this.bb = bb;
    }

    public static RectWireframe of(IBounded box) {
        return new RectWireframe(BoundingBox.of(box));
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, Fill.ALWAYS);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        for (Coord c : this) {
            block.set(editor, rand, c, p);
        }
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectWireframeIterator(this, this.bb);
    }

    private class RectWireframeIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord c1;
        Coord c2;

        public RectWireframeIterator(RectWireframe rectWireframe, BoundingBox bb) {
            this.c1 = bb.getStart();
            this.c2 = bb.getEnd();
            this.cursor = this.c1.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.c2.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.c2.getZ() && this.cursor.getX() == this.c2.getX()) {
                this.cursor = this.c1.withY(this.cursor.getY());
                this.cursor.add(Cardinal.UP);
                return toReturn;
            }
            if (this.cursor.getY() == this.c1.getY() || this.cursor.getY() == this.c2.getY()) {
                if (this.cursor.getX() == this.c2.getX()) {
                    this.cursor = this.cursor.withX(this.c1.getX());
                    this.cursor.add(Cardinal.SOUTH);
                    return toReturn;
                }
                if (this.cursor.getZ() == this.c1.getZ() || this.cursor.getZ() == this.c2.getZ()) {
                    this.cursor.add(Cardinal.EAST);
                    return toReturn;
                }
                if (this.cursor.getX() == this.c1.getX()) {
                    this.cursor = this.cursor.withX(this.c2.getX());
                    return toReturn;
                }
            }
            if (this.cursor.getX() == this.c1.getX()) {
                this.cursor = this.cursor.withX(this.c2.getX());
                return toReturn;
            }
            if (this.cursor.getX() == this.c2.getX()) {
                this.cursor = Coord.of(this.c1.getX(), this.cursor.getY(), this.c2.getZ());
                return toReturn;
            }
            this.cursor = this.cursor.withX(this.c2.getX());
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

