/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.IShape;
import com.greymerk.roguelike.editor.shapes.RectHollow;
import com.greymerk.roguelike.editor.shapes.RectPyramid;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.RectWireframe;
import com.greymerk.roguelike.editor.shapes.Sphere;

public enum Shape {
    RECTSOLID,
    RECTHOLLOW,
    RECTPYRAMID,
    RECTWIREFRAME,
    SPHERE;


    public static IShape get(Shape type, BoundingBox bb) {
        switch (type.ordinal()) {
            case 0: {
                return new RectSolid(bb);
            }
            case 1: {
                return new RectHollow(bb);
            }
            case 2: {
                return new RectPyramid(bb);
            }
            case 3: {
                return RectWireframe.of(bb);
            }
            case 4: {
                return new Sphere(bb);
            }
        }
        return new RectSolid(bb);
    }
}

