/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.shapes;

import com.greymerk.roguelike.editor.BlockContext;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.IShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.minecraft.class_5819;

public class Sphere
implements IShape {
    private BoundingBox bb;

    public Sphere(BoundingBox bb) {
        this.bb = bb;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new SphereIterator(this, this.bb);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block) {
        this.fill(editor, rand, block, Fill.ALWAYS);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IBlockFactory block, Predicate<BlockContext> p) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, p);
        }
    }

    @Override
    public List<Coord> get() {
        return StreamSupport.stream(this.spliterator(), false).toList();
    }

    private class SphereIterator
    implements Iterator<Coord> {
        private Coord centre;
        private int radius;
        private int layer;
        private int row;
        private int col;
        private Cardinal dir;
        private boolean top;

        public SphereIterator(Sphere sphere, BoundingBox bb) {
            this.centre = bb.getStart();
            Coord s = bb.getStart();
            Coord e = bb.getEnd();
            Coord diff = e.sub(s);
            int r = diff.getX();
            r = r < diff.getY() ? diff.getY() : r;
            this.radius = r = r < diff.getZ() ? diff.getZ() : r;
            this.layer = 0;
            this.row = 0;
            this.col = 0;
            this.top = true;
            this.dir = Cardinal.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.layer < this.radius;
        }

        @Override
        public Coord next() {
            Coord toReturn = this.centre.copy();
            toReturn.add(this.top ? Cardinal.UP : Cardinal.DOWN, this.layer);
            toReturn.add(this.dir, this.row);
            toReturn.add(Cardinal.left(this.dir), this.col);
            if (this.dir != Cardinal.NORTH || this.top) {
                if (this.dir == Cardinal.NORTH) {
                    this.top = false;
                }
                this.dir = Cardinal.left(this.dir);
                return toReturn;
            }
            ++this.col;
            if (this.inRange(this.col, this.layer, this.row)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.col = 0;
            ++this.row;
            if (this.inRange(this.col, this.layer, this.row)) {
                this.dir = Cardinal.left(this.dir);
                this.top = true;
                return toReturn;
            }
            this.row = 0;
            ++this.layer;
            this.dir = Cardinal.left(this.dir);
            this.top = true;
            return toReturn;
        }

        private boolean inRange(int x, int y, int z) {
            return x * x + y * y + z * z < this.radius * this.radius;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

