/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.events;

import com.greymerk.roguelike.dungeon.Dungeon;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.WorldEditor;
import com.greymerk.roguelike.state.RoguelikeState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class WorldTickGenerateRooms
implements ServerTickEvents.StartWorldTick {
    public void onStartTick(class_3218 world) {
        if (!RoguelikeState.flagForGenerationCheck) {
            return;
        }
        WorldEditor editor = WorldEditor.of(world);
        MinecraftServer server = world.method_8503();
        RoguelikeState state = RoguelikeState.getServerState(editor.getRegistryKey(), server);
        if (!state.hasDungeons()) {
            return;
        }
        state.getLoadedDungeons(editor).stream().filter(d -> !d.hasLayout()).forEach(d -> {
            Coord pos = d.getPos();
            state.removeDungeon((Dungeon)d);
            Dungeon.generate(editor, pos);
        });
        state.getLoadedRooms(editor).stream().sorted((a, b) -> a.getWorldPos().getY() - b.getWorldPos().getY()).forEach(room -> {
            editor.clearStats();
            room.generate(editor);
            room.applyFilters(editor);
            room.setGenerated(true);
            room.mergeStats(editor.getStatistics());
        });
        state.update(editor);
        RoguelikeState.flagForGenerationCheck = false;
    }
}

