/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.filter;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.filter.IFilter;
import com.greymerk.roguelike.settings.ILevelSettings;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class ExplosiveTrapFilter
implements IFilter {
    @Override
    public void apply(IWorldEditor editor, class_5819 rand, ILevelSettings settings, IBounded box) {
        box.forEach(pos -> {
            if (rand.method_43048(200) == 0) {
                this.addTrap(editor, rand, (Coord)pos);
            }
        });
    }

    private void addTrap(IWorldEditor editor, class_5819 rand, Coord pos) {
        if (!editor.isAir(pos)) {
            return;
        }
        if (!editor.isFaceFullSquare(pos.copy().add(Cardinal.DOWN), Cardinal.UP)) {
            return;
        }
        if (!this.isEncased(editor, pos.copy().add(Cardinal.DOWN, 2))) {
            return;
        }
        if (editor.hasBlockEntity(pos.copy().add(Cardinal.DOWN, 2))) {
            return;
        }
        MetaBlock.of(class_2246.field_10158).set(editor, pos);
        if (rand.method_43056()) {
            MetaBlock.of(class_2246.field_10375).set(editor, pos.copy().add(Cardinal.DOWN, 2));
        }
    }

    private boolean isEncased(IWorldEditor editor, Coord pos) {
        for (Cardinal dir : Cardinal.all) {
            if (editor.isSolid(pos.copy().add(dir))) continue;
            return false;
        }
        return true;
    }
}

