/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.filter;

import com.greymerk.roguelike.filter.ChainFilter;
import com.greymerk.roguelike.filter.CobwebFilter;
import com.greymerk.roguelike.filter.DecoratedPotFilter;
import com.greymerk.roguelike.filter.EncaseFilter;
import com.greymerk.roguelike.filter.ExplosiveTrapFilter;
import com.greymerk.roguelike.filter.IFilter;
import com.greymerk.roguelike.filter.LeafLitterFilter;
import com.greymerk.roguelike.filter.MudFilter;
import com.greymerk.roguelike.filter.SculkFilter;
import com.greymerk.roguelike.filter.VineFilter;
import com.greymerk.roguelike.filter.WireframeFilter;

public enum Filter {
    VINE,
    ENCASE,
    WIREFRAME,
    COBWEB,
    MUD,
    POTS,
    SCULK,
    EXPLOSIVE,
    LEAFLITTER,
    CHAINS;


    public static IFilter get(Filter type) {
        switch (type.ordinal()) {
            case 0: {
                return new VineFilter();
            }
            case 1: {
                return new EncaseFilter();
            }
            case 2: {
                return new WireframeFilter();
            }
            case 3: {
                return new CobwebFilter();
            }
            case 4: {
                return new MudFilter();
            }
            case 5: {
                return new DecoratedPotFilter();
            }
            case 6: {
                return new SculkFilter();
            }
            case 7: {
                return new ExplosiveTrapFilter();
            }
            case 8: {
                return new LeafLitterFilter();
            }
            case 9: {
                return new ChainFilter();
            }
        }
        return new VineFilter();
    }
}

