/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.filter;

import com.greymerk.roguelike.dungeon.fragment.parts.Fungus;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.FlowerPot;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.editor.factories.BlockJumble;
import com.greymerk.roguelike.editor.shapes.Shape;
import com.greymerk.roguelike.filter.IFilter;
import com.greymerk.roguelike.settings.ILevelSettings;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class MudFilter
implements IFilter {
    @Override
    public void apply(IWorldEditor editor, class_5819 rand, ILevelSettings settings, IBounded box) {
        for (Coord pos : box.getShape(Shape.RECTSOLID)) {
            if (rand.method_43048(40) != 0 || !this.validLocation(editor, rand, pos)) continue;
            this.generate(editor, rand, pos, rand.method_43048(3) + 2);
        }
    }

    private void generate(IWorldEditor editor, class_5819 rand, Coord pos, int counter) {
        if (counter <= 0) {
            return;
        }
        for (Cardinal dir : Cardinal.directions) {
            if (rand.method_43056()) continue;
            Coord next = pos.copy();
            next.add(dir);
            this.generate(editor, rand, next, counter - 1);
        }
        if (!this.validLocation(editor, rand, pos)) {
            return;
        }
        BlockJumble wet = new BlockJumble();
        wet.add(MetaBlock.of(class_2246.field_10460));
        wet.add(MetaBlock.of(class_2246.field_10114));
        wet.add(MetaBlock.of(class_2246.field_10402));
        BlockJumble dry = new BlockJumble();
        dry.add(MetaBlock.of(class_2246.field_10520));
        dry.add(MetaBlock.of(class_2246.field_10566));
        dry.add(MetaBlock.of(class_2246.field_10253));
        switch (counter) {
            case 4: 
            case 5: {
                MetaBlock.of(class_2246.field_10566).set(editor, pos);
            }
            case 3: {
                if (rand.method_43056()) {
                    MetaBlock.of(class_2246.field_10253).set(editor, pos);
                    break;
                }
            }
            case 2: {
                wet.set(editor, rand, pos);
                break;
            }
            case 1: {
                if (rand.method_43056()) {
                    wet.set(editor, rand, pos);
                    break;
                }
            }
            default: {
                MetaBlock.of(class_2246.field_10382).set(editor, pos);
                return;
            }
        }
        if (rand.method_43048(3) != 0) {
            return;
        }
        BlockJumble shrooms = new BlockJumble();
        shrooms.add(MetaBlock.of(FlowerPot.getFlower(FlowerPot.BROWNMUSHROOM)));
        shrooms.add(MetaBlock.of(FlowerPot.getFlower(FlowerPot.REDMUSHROOM)));
        if (rand.method_43048(3) == 0) {
            Fungus.generate(editor, rand, pos.copy().add(Cardinal.UP));
        } else {
            shrooms.set(editor, rand, pos.copy().add(Cardinal.UP));
        }
    }

    private boolean validLocation(IWorldEditor editor, class_5819 rand, Coord origin) {
        if (!editor.isSolid(origin)) {
            return false;
        }
        if (!editor.isAir(origin.copy().add(Cardinal.UP))) {
            return false;
        }
        if (editor.isAir(origin.copy().add(Cardinal.DOWN))) {
            return false;
        }
        for (Cardinal dir : Cardinal.directions) {
            if (editor.isSolid(origin.copy().add(dir))) continue;
            return false;
        }
        return true;
    }
}

