/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.settings;

import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.settings.level.LevelSettingsBlackstone;
import com.greymerk.roguelike.settings.level.LevelSettingsCrumbledMossy;
import com.greymerk.roguelike.settings.level.LevelSettingsCrumbledStone;
import com.greymerk.roguelike.settings.level.LevelSettingsDarkOak;
import com.greymerk.roguelike.settings.level.LevelSettingsDeepslateBrick;
import com.greymerk.roguelike.settings.level.LevelSettingsDefault;
import com.greymerk.roguelike.settings.level.LevelSettingsMossy;
import com.greymerk.roguelike.settings.level.LevelSettingsNether;
import com.greymerk.roguelike.settings.level.LevelSettingsOak;
import com.greymerk.roguelike.settings.level.LevelSettingsRandom;
import com.greymerk.roguelike.settings.level.LevelSettingsSpruce;
import com.greymerk.roguelike.settings.level.LevelSettingsStone;
import com.greymerk.roguelike.settings.level.LevelSettingsTiledDeepslate;

public enum LevelSettings {
    DEFAULT,
    OAK,
    SPRUCE,
    DARK_OAK,
    STONE,
    CRUMBLED_STONE,
    MOSSY,
    CRUMBLED_MOSSY,
    SLATE,
    TILED_SLATE,
    NETHER,
    BLACKSTONE,
    RANDOM;


    public static ILevelSettings fromType(LevelSettings type) {
        switch (type.ordinal()) {
            case 0: {
                return new LevelSettingsDefault();
            }
            case 11: {
                return new LevelSettingsBlackstone();
            }
            case 7: {
                return new LevelSettingsCrumbledMossy();
            }
            case 5: {
                return new LevelSettingsCrumbledStone();
            }
            case 3: {
                return new LevelSettingsDarkOak();
            }
            case 6: {
                return new LevelSettingsMossy();
            }
            case 10: {
                return new LevelSettingsNether();
            }
            case 1: {
                return new LevelSettingsOak();
            }
            case 8: {
                return new LevelSettingsDeepslateBrick();
            }
            case 2: {
                return new LevelSettingsSpruce();
            }
            case 4: {
                return new LevelSettingsStone();
            }
            case 9: {
                return new LevelSettingsTiledDeepslate();
            }
            case 12: {
                return new LevelSettingsRandom();
            }
        }
        return new LevelSettingsDefault();
    }

    public static ILevelSettings get(String name) {
        LevelSettings type = LevelSettings.valueOf(name.toUpperCase());
        return LevelSettings.fromType(type);
    }
}

