/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.settings.level;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.dungeon.room.RoomProvider;
import com.greymerk.roguelike.filter.Filter;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.settings.LevelSettings;
import com.greymerk.roguelike.settings.LevelSettingsBase;
import com.greymerk.roguelike.theme.Theme;
import com.greymerk.roguelike.util.WeightedChoice;
import com.greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;

public class LevelSettingsCrumbledStone
extends LevelSettingsBase
implements ILevelSettings {
    public LevelSettingsCrumbledStone() {
        this.theme = Theme.getTheme(Theme.CRUMBLEDSTONE);
        this.rooms = new RoomProvider();
        this.rooms.addRandomChoice(Room.CORRIDOR, 10);
        this.rooms.addRandomChoice(Room.CRYPT, 5);
        this.rooms.addRandomChoice(Room.PRISON, 3);
        this.rooms.addRandomChoice(Room.BALCONY, 1);
        this.rooms.addRoomOnce(Room.PANOPTICON);
        this.rooms.addRoomOnce(Room.ENDER);
        this.rooms.addRoomSometimes(Room.PIT, 0.2);
        this.walls = new WeightedRandomizer(10);
        this.walls.add(new WeightedChoice<Fragment>(Fragment.WALL_EMPTY, 15));
        this.walls.add(new WeightedChoice<Fragment>(Fragment.WALL_SPAWNER, 2));
        this.walls.add(new WeightedChoice<Fragment>(Fragment.WALL_CHEST, 1));
        this.walls.add(new WeightedChoice<Fragment>(Fragment.WALL_FOOD_BARREL, 1));
        this.alcoves.add(new WeightedChoice<Fragment>(Fragment.ALCOVE_PRISON_CELL, 10));
        this.alcoves.add(new WeightedChoice<Fragment>(Fragment.ALCOVE_CRYPT, 5));
        this.alcoves.add(new WeightedChoice<Fragment>(Fragment.BOOK_SHELF, 3));
        this.filters = new ArrayList();
        this.filters.add(Filter.get(Filter.COBWEB));
        this.filters.add(Filter.get(Filter.CHAINS));
    }

    @Override
    public String getName() {
        return LevelSettings.CRUMBLED_STONE.name();
    }

    @Override
    public Difficulty getDifficulty() {
        return Difficulty.MEDIUM;
    }
}

