/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.state;

import com.google.gson.JsonElement;
import com.greymerk.roguelike.debug.Debug;
import com.greymerk.roguelike.dungeon.Dungeon;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.Statistics;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.StreamSupport;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class RoguelikeState
extends class_18 {
    public static final Codec<List<Dungeon>> DUNGEON_LIST_CODEC = Codec.list(Dungeon.CODEC);
    public static final Codec<RoguelikeState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DUNGEON_LIST_CODEC.fieldOf("dungeons").forGetter(state -> state.dungeons)).apply((Applicative)instance, dungeonList -> new RoguelikeState((List<Dungeon>)dungeonList)));
    public static boolean flagForGenerationCheck = true;
    private List<Dungeon> dungeons = new CopyOnWriteArrayList<Dungeon>();

    private RoguelikeState(List<Dungeon> dungeonList) {
        this.dungeons.addAll(dungeonList);
    }

    private RoguelikeState() {
    }

    public void addDungeon(Dungeon toAdd) {
        this.dungeons.add(toAdd);
        this.method_80();
    }

    public void removeDungeon(Dungeon toRemove) {
        this.dungeons.remove(toRemove);
        this.method_80();
    }

    public boolean hasDungeons() {
        return !this.dungeons.isEmpty();
    }

    public void update(IWorldEditor editor) {
        if (Debug.isOn()) {
            this.dungeons.stream().filter(d -> d.isGenerated()).forEach(d -> {
                Statistics stats = d.getStatistics();
                Debug.toFile(editor, "RoguelikeDungeons_" + d.getPos().toString().replaceAll(" ", "_") + "_Loot.json", (JsonElement)Statistics.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stats).getOrThrow());
                Debug.info("Dungeon @" + d.getPos().toString() + " completed generating rooms.");
            });
        }
        this.dungeons.removeIf(d -> d.isGenerated());
        this.method_80();
    }

    public List<Dungeon> getLoadedDungeons(IWorldEditor editor) {
        return this.dungeons.stream().filter(d -> editor.isChunkLoaded(d.getPos())).toList();
    }

    public List<IRoom> getLoadedRooms(IWorldEditor editor) {
        return this.dungeons.stream().flatMap(d -> StreamSupport.stream(d.spliterator(), false)).filter(r -> !r.isGenerated()).filter(r -> editor.surroundingChunksLoaded(r.getWorldPos())).toList();
    }

    public static RoguelikeState getServerState(class_5321<class_1937> worldKey, MinecraftServer server) {
        return (RoguelikeState)server.method_3847(worldKey).method_17983().method_17924(RoguelikeState.getPersistentStateType());
    }

    public static class_10741<RoguelikeState> getPersistentStateType() {
        return new class_10741("roguelike", RoguelikeState::new, CODEC, null);
    }
}

