/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.theme;

import com.greymerk.roguelike.theme.BlockSet;
import com.greymerk.roguelike.theme.IBlockSet;
import com.greymerk.roguelike.theme.ITheme;
import com.greymerk.roguelike.theme.themes.ThemeBlack;
import com.greymerk.roguelike.theme.themes.ThemeCrumbledMossy;
import com.greymerk.roguelike.theme.themes.ThemeCrumbledStone;
import com.greymerk.roguelike.theme.themes.ThemeDarkOak;
import com.greymerk.roguelike.theme.themes.ThemeDefault;
import com.greymerk.roguelike.theme.themes.ThemeMossy;
import com.greymerk.roguelike.theme.themes.ThemeNether;
import com.greymerk.roguelike.theme.themes.ThemeOak;
import com.greymerk.roguelike.theme.themes.ThemeRedNether;
import com.greymerk.roguelike.theme.themes.ThemeSlate;
import com.greymerk.roguelike.theme.themes.ThemeSpruce;
import com.greymerk.roguelike.theme.themes.ThemeStone;
import com.greymerk.roguelike.theme.themes.ThemeTiledSlate;
import com.greymerk.roguelike.theme.themes.ThemeTower;
import com.greymerk.roguelike.theme.themes.ThemeWarped;
import net.minecraft.class_5819;

public enum Theme {
    DEFAULT,
    TOWER,
    OAK,
    SPRUCE,
    DARKOAK,
    STONE,
    CRUMBLEDSTONE,
    MOSSY,
    CRUMBLEDMOSSY,
    SLATE,
    TILEDSLATE,
    NETHER,
    REDNETHER,
    WARPED,
    BLACK;


    public static ITheme getTheme(Theme type) {
        switch (type.ordinal()) {
            case 0: {
                return new ThemeDefault();
            }
            case 1: {
                return new ThemeTower();
            }
            case 2: {
                return new ThemeOak();
            }
            case 3: {
                return new ThemeSpruce();
            }
            case 4: {
                return new ThemeDarkOak();
            }
            case 5: {
                return new ThemeStone();
            }
            case 6: {
                return new ThemeCrumbledStone();
            }
            case 7: {
                return new ThemeMossy();
            }
            case 8: {
                return new ThemeCrumbledMossy();
            }
            case 9: {
                return new ThemeSlate();
            }
            case 10: {
                return new ThemeTiledSlate();
            }
            case 11: {
                return new ThemeNether();
            }
            case 12: {
                return new ThemeRedNether();
            }
            case 13: {
                return new ThemeWarped();
            }
            case 14: {
                return new ThemeBlack();
            }
        }
        return new ThemeDefault();
    }

    public static ITheme get(String name) {
        Theme type = Theme.valueOf(name.toUpperCase());
        return Theme.getTheme(type);
    }

    public static boolean contains(String name) {
        for (Theme value : Theme.values()) {
            if (!value.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static ITheme getRandom(class_5819 rand) {
        return Theme.getTheme(Theme.values()[rand.method_43048(Theme.values().length)]);
    }

    public static ITheme of(BlockSet primary, BlockSet secondary) {
        return new ThemeCustom(primary, secondary);
    }

    private static class ThemeCustom
    implements ITheme {
        BlockSet primary;
        BlockSet secondary;

        public ThemeCustom(BlockSet primary, BlockSet secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public IBlockSet getPrimary() {
            return this.primary;
        }

        @Override
        public IBlockSet getSecondary() {
            return this.secondary;
        }

        @Override
        public String getName() {
            return "custom";
        }
    }
}

