/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.treasure.chest.ChestType;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.chest.TreasureChest;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;

public enum Treasure {
    ALL,
    EMPTY,
    STARTER,
    ARMOR,
    WEAPON,
    TOOL,
    BLOCK,
    ORE,
    FOOD,
    SUPPLY,
    MUSIC,
    BREWING;


    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Difficulty diff, Coord pos, Treasure type) {
        return Treasure.generate(editor, rand, diff, pos, type, ChestType.CHEST);
    }

    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Difficulty diff, Coord pos, Cardinal dir, Treasure type) {
        return Treasure.generate(editor, rand, diff, pos, dir, type, ChestType.CHEST);
    }

    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Difficulty diff, Coord pos, Treasure type, ChestType block) {
        return TreasureChest.generate(editor, rand, diff, pos, type, block);
    }

    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Difficulty diff, Coord pos, Cardinal dir, Treasure type, ChestType block) {
        return TreasureChest.generate(editor, rand, diff, pos, dir, type, block);
    }

    public static Optional<class_5321<class_52>> getLootTable(Treasure type, Difficulty diff) {
        Optional<class_2960> id = Treasure.getTableIdentifier(type, diff);
        if (id.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id.get()));
    }

    public static Optional<class_2960> getTableIdentifier(Treasure type, Difficulty diff) {
        String tier = diff.lt(Difficulty.HARD) ? "1" : "2";
        String path = "chests/";
        switch (type.ordinal()) {
            case 2: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "starter")));
            }
            case 3: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "armor" + tier)));
            }
            case 6: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "block" + tier)));
            }
            case 11: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "brewing")));
            }
            case 8: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "food" + tier)));
            }
            case 10: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "music")));
            }
            case 7: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "ore" + tier)));
            }
            case 9: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "supply" + tier)));
            }
            case 5: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "tool" + tier)));
            }
            case 4: {
                return Optional.of(class_2960.method_60655((String)"roguelike", (String)(path + "weapon" + tier)));
            }
        }
        return Optional.empty();
    }
}

