/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public enum Enchant {
    MENDING,
    UNBREAKING,
    CURSE_OF_VANISHING,
    CURSE_OF_BINDING,
    EFFICIENCY,
    SILKTOUCH,
    FORTUNE,
    SHARPNESS,
    SMITE,
    ARTHOPODS,
    FIREASPECT,
    KNOCKBACK,
    LOOTING,
    AQUAAFFINITY,
    RESPIRATION,
    FEATHERFALLING,
    DEPTHSTRIDER,
    FROSTWALKER,
    PROTECTION,
    BLASTPROTECTION,
    FIREPROTECTION,
    PROJECTILEPROTECTION,
    THORNS,
    POWER,
    PUNCH,
    FLAME,
    INFINITY,
    LURE,
    LUCKOFTHESEA,
    CHANNELING,
    IMPALING,
    RIPTIDE,
    LOYALTY,
    MULTISHOT,
    PIERCING,
    QUICK_CHARGE,
    SOUL_SPEED,
    SWIFT_SNEAK;

    public static final List<Enchant> common;
    public static final List<Enchant> endgame;
    public static final List<Enchant> cursed;

    public static class_6880<class_1887> getEnchant(class_5455 reg, Enchant type) {
        class_2378 enchantments = reg.method_30530(class_7924.field_41265);
        String ns = "minecraft";
        String path = Enchant.getName(type);
        class_2960 id = class_2960.method_60655((String)ns, (String)path);
        return (class_6880)enchantments.method_10223(id).get();
    }

    public static String getName(Enchant type) {
        switch (type.ordinal()) {
            case 7: {
                return "sharpness";
            }
            case 8: {
                return "smite";
            }
            case 9: {
                return "bane_of_arthropods";
            }
            case 12: {
                return "looting";
            }
            case 11: {
                return "knockback";
            }
            case 10: {
                return "fire_aspect";
            }
            case 13: {
                return "aqua_affinity";
            }
            case 14: {
                return "respiration";
            }
            case 15: {
                return "feather_falling";
            }
            case 16: {
                return "depth_strider";
            }
            case 18: {
                return "protection";
            }
            case 19: {
                return "blast_protection";
            }
            case 20: {
                return "fire_protection";
            }
            case 21: {
                return "projectile_protection";
            }
            case 22: {
                return "thorns";
            }
            case 1: {
                return "unbreaking";
            }
            case 4: {
                return "efficiency";
            }
            case 5: {
                return "silk_touch";
            }
            case 6: {
                return "fortune";
            }
            case 23: {
                return "power";
            }
            case 24: {
                return "punch";
            }
            case 25: {
                return "flame";
            }
            case 26: {
                return "infinity";
            }
            case 27: {
                return "lure";
            }
            case 28: {
                return "luck_of_the_sea";
            }
            case 0: {
                return "mending";
            }
            case 29: {
                return "channeling";
            }
            case 3: {
                return "binding_curse";
            }
            case 2: {
                return "vanishing_curse";
            }
            case 17: {
                return "frost_walker";
            }
            case 30: {
                return "impaling";
            }
            case 32: {
                return "loyalty";
            }
            case 33: {
                return "multishot";
            }
            case 34: {
                return "piercing";
            }
            case 35: {
                return "quick_charge";
            }
            case 31: {
                return "riptide";
            }
            case 36: {
                return "soul_speed";
            }
            case 37: {
                return "swift_sneak";
            }
        }
        return "efficiency";
    }

    public static int getMaxRank(Enchant type) {
        switch (type.ordinal()) {
            case 7: {
                return 5;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 5;
            }
            case 12: {
                return 3;
            }
            case 11: {
                return 2;
            }
            case 10: {
                return 2;
            }
            case 13: {
                return 1;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 3;
            }
            case 18: {
                return 4;
            }
            case 19: {
                return 4;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 3;
            }
            case 1: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 3;
            }
            case 23: {
                return 5;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 27: {
                return 3;
            }
            case 28: {
                return 3;
            }
            case 0: {
                return 1;
            }
            case 29: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 30: {
                return 5;
            }
            case 32: {
                return 3;
            }
            case 33: {
                return 1;
            }
            case 34: {
                return 4;
            }
            case 35: {
                return 3;
            }
            case 31: {
                return 3;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return 3;
            }
        }
        return 1;
    }

    public static int getRandomRank(class_5819 rand, Enchant type, Difficulty diff) {
        int max = Enchant.getMaxRank(type);
        if (max == 1) {
            return 1;
        }
        if (diff == Difficulty.HARDEST) {
            return max;
        }
        return rand.method_39332(1, max);
    }

    public static int getLevel(class_5819 rand, Difficulty diff) {
        switch (diff) {
            case HARDEST: {
                return 30 + rand.method_43048(10);
            }
            case HARD: {
                return 15 + rand.method_43048(15);
            }
            case MEDIUM: {
                return 5 + rand.method_43048(15);
            }
            case EASY: {
                return 1 + rand.method_43048(10);
            }
            case EASIEST: {
                return 1 + rand.method_43048(5);
            }
        }
        return 1;
    }

    public static class_1799 enchantItem(class_5455 reg, class_5819 rand, class_1799 item, Difficulty diff) {
        return Enchant.enchantItem(reg, rand, item, Enchant.getLevel(rand, diff));
    }

    public static class_1799 enchantItem(class_5455 reg, class_5819 rand, class_1799 item, int enchantmentLevel) {
        if (item == null || item == class_1799.field_8037) {
            return class_1799.field_8037;
        }
        List<class_1889> enchants = Enchant.enchantsForItem(reg, rand, item, enchantmentLevel, (class_6862<class_1887>)class_9636.field_51547);
        if (enchants.isEmpty()) {
            return item;
        }
        if (item.method_31574(class_1802.field_8529)) {
            return Enchant.getBook(enchants.getFirst());
        }
        enchants.forEach(toAdd -> item.method_7978(toAdd.comp_3486(), toAdd.comp_3487()));
        return item;
    }

    public static List<class_1889> enchantsForItem(class_5455 reg, class_5819 rand, class_1799 item, int level, class_6862<class_1887> tag) {
        Optional optional = reg.method_30530(class_7924.field_41265).method_46733(tag);
        if (optional.isEmpty()) {
            return List.of();
        }
        List enchants = class_1890.method_8230((class_5819)rand, (class_1799)item, (int)level, (Stream)((class_6885.class_6888)optional.get()).method_40239());
        return enchants;
    }

    public static class_1799 getBook(class_5455 reg, class_5819 rand, Difficulty diff) {
        if (diff == Difficulty.HARDEST && rand.method_43048(6) == 0) {
            Enchant type = endgame.get(rand.method_43048(endgame.size()));
            return Enchant.getBook(reg, rand, type, diff);
        }
        if (rand.method_43048(6) == 0) {
            return Enchant.getBook(reg, MENDING);
        }
        Optional optional = reg.method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
        if (optional.isEmpty()) {
            return new class_1799((class_1935)class_1802.field_8529);
        }
        List<class_1889> enchants = Enchant.enchantsForItem(reg, rand, new class_1799((class_1935)class_1802.field_8529), Enchant.getLevel(rand, diff), (class_6862<class_1887>)class_9636.field_51547);
        if (enchants.isEmpty()) {
            return new class_1799((class_1935)class_1802.field_8529);
        }
        RandHelper.shuffle(enchants, rand);
        return Enchant.getBook(enchants.getFirst());
    }

    public static class_1799 getBook(class_5455 reg, class_5819 rand, Enchant type, Difficulty diff) {
        return Enchant.getBook(new class_1889(Enchant.getEnchant(reg, type), Enchant.getRandomRank(rand, type, diff)));
    }

    public static class_1799 getBook(class_5455 reg, Enchant type) {
        return Enchant.getBook(new class_1889(Enchant.getEnchant(reg, type), Enchant.getMaxRank(type)));
    }

    public static class_1799 getBook(class_1889 ench) {
        class_1799 book = new class_1799((class_1935)class_1802.field_8598);
        class_9304 component = (class_9304)book.method_58694(class_9334.field_49643);
        class_9304.class_9305 builder = new class_9304.class_9305(component);
        builder.method_57550(ench.comp_3486(), ench.comp_3487());
        book.method_57379(class_9334.field_49643, (Object)builder.method_57549());
        return book;
    }

    static {
        common = List.of(UNBREAKING, EFFICIENCY, SILKTOUCH, FORTUNE, SHARPNESS, SMITE, ARTHOPODS, FIREASPECT, KNOCKBACK, LOOTING, AQUAAFFINITY, RESPIRATION, FEATHERFALLING, DEPTHSTRIDER, FROSTWALKER, PROTECTION, BLASTPROTECTION, FIREPROTECTION, PROJECTILEPROTECTION, THORNS, POWER, PUNCH, FLAME, INFINITY, LURE, LUCKOFTHESEA, CHANNELING, IMPALING, RIPTIDE, LOYALTY, MULTISHOT, PIERCING, QUICK_CHARGE);
        endgame = List.of(SOUL_SPEED, SWIFT_SNEAK);
        cursed = List.of(CURSE_OF_VANISHING, CURSE_OF_BINDING);
    }
}

