/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.loot.Equipment;
import com.greymerk.roguelike.util.IWeighted;
import com.greymerk.roguelike.util.WeightedChoice;
import com.greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5819;

public enum Quality {
    WOOD,
    STONE,
    COPPER,
    IRON,
    GOLD,
    DIAMOND,
    NETHERITE;

    private static Map<Difficulty, IWeighted<Quality>> armourQuality;
    private static Map<Difficulty, IWeighted<Quality>> weaponQuality;

    private static WeightedRandomizer<Quality> create(int wood, int stone, int copper, int iron, int gold, int diamond, int netherite) {
        WeightedRandomizer<Quality> randomizer = new WeightedRandomizer<Quality>();
        randomizer.add(new WeightedChoice<Quality>(WOOD, wood));
        randomizer.add(new WeightedChoice<Quality>(STONE, stone));
        randomizer.add(new WeightedChoice<Quality>(COPPER, copper));
        randomizer.add(new WeightedChoice<Quality>(IRON, iron));
        randomizer.add(new WeightedChoice<Quality>(GOLD, gold));
        randomizer.add(new WeightedChoice<Quality>(DIAMOND, diamond));
        randomizer.add(new WeightedChoice<Quality>(NETHERITE, netherite));
        return randomizer;
    }

    public static Quality get(class_5819 rand, Difficulty diff, Equipment type) {
        switch (type) {
            case HELMET: 
            case CHEST: 
            case LEGS: 
            case FEET: {
                return armourQuality.get((Object)diff).get(rand);
            }
            case PICK: 
            case AXE: 
            case SHOVEL: 
            case SWORD: 
            case BOW: {
                return weaponQuality.get((Object)diff).get(rand);
            }
        }
        return WOOD;
    }

    public static Quality get(Difficulty diff) {
        switch (diff) {
            case EASIEST: {
                return WOOD;
            }
            case EASY: {
                return STONE;
            }
            case MEDIUM: {
                return IRON;
            }
            case HARD: {
                return GOLD;
            }
            case HARDEST: {
                return DIAMOND;
            }
        }
        return WOOD;
    }

    public static Quality getArmourQuality(class_5819 rand, Difficulty diff) {
        return armourQuality.get((Object)diff).get(rand);
    }

    public static Quality getToolQuality(class_5819 rand, Difficulty diff) {
        return weaponQuality.get((Object)diff).get(rand);
    }

    public static Quality getWeaponQuality(class_5819 rand, Difficulty diff) {
        return weaponQuality.get((Object)diff).get(rand);
    }

    static {
        armourQuality = new HashMap<Difficulty, IWeighted<Quality>>();
        weaponQuality = new HashMap<Difficulty, IWeighted<Quality>>();
        armourQuality.put(Difficulty.EASIEST, Quality.create(300, 80, 40, 20, 5, 2, 1));
        armourQuality.put(Difficulty.EASY, Quality.create(200, 60, 40, 20, 5, 2, 1));
        armourQuality.put(Difficulty.MEDIUM, Quality.create(50, 60, 40, 20, 5, 3, 1));
        armourQuality.put(Difficulty.HARD, Quality.create(5, 20, 40, 60, 5, 5, 1));
        armourQuality.put(Difficulty.HARDEST, Quality.create(1, 5, 10, 50, 5, 10, 1));
        weaponQuality.put(Difficulty.EASIEST, Quality.create(100, 200, 100, 50, 2, 1, 1));
        weaponQuality.put(Difficulty.EASY, Quality.create(50, 100, 100, 50, 5, 2, 1));
        weaponQuality.put(Difficulty.MEDIUM, Quality.create(10, 40, 40, 80, 5, 5, 1));
        weaponQuality.put(Difficulty.HARD, Quality.create(5, 10, 10, 70, 5, 5, 1));
        weaponQuality.put(Difficulty.HARDEST, Quality.create(1, 5, 5, 50, 5, 10, 1));
    }
}

