/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.potions;

import com.greymerk.roguelike.treasure.loot.ItemHideFlags;
import com.greymerk.roguelike.treasure.loot.Loot;
import com.greymerk.roguelike.treasure.loot.potions.PotionEffect;
import com.greymerk.roguelike.treasure.loot.potions.PotionForm;
import com.greymerk.roguelike.treasure.loot.potions.PotionItem;
import com.greymerk.roguelike.util.Color;
import com.greymerk.roguelike.util.TextFormat;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_5819;
import net.minecraft.class_9334;

public enum PotionMixture {
    TEQUILA,
    MOONSHINE,
    ABSINTHE,
    VILE,
    LAUDANUM,
    ANIMUS,
    STOUT,
    STAMINA,
    NECTAR,
    COFFEE,
    AURA;


    public static class_1799 getPotion(class_5819 rand, PotionMixture type) {
        switch (type.ordinal()) {
            case 0: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.STRENGTH, 3, 30 + rand.method_43048(60));
                PotionEffect.addCustomEffect(potion, PotionEffect.FATIGUE, 1, 30 + rand.method_43048(60));
                Loot.setItemName(potion, "Cactus");
                Loot.setItemLore(potion, "Liquid sunrise");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(255, 232, 196));
                return potion;
            }
            case 4: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.REGEN, 3, 8);
                PotionEffect.addCustomEffect(potion, PotionEffect.WEAKNESS, 2, 5);
                PotionEffect.addCustomEffect(potion, PotionEffect.SLOWNESS, 2, 5);
                PotionEffect.addCustomEffect(potion, PotionEffect.FATIGUE, 2, 5);
                PotionEffect.addCustomEffect(potion, PotionEffect.NAUSIA, 1, 5);
                Loot.setItemName(potion, "Laudanum");
                Loot.setItemLore(potion, "A medicinal tincture.");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(150, 50, 0));
                return potion;
            }
            case 1: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.DAMAGE, 1, 1);
                PotionEffect.addCustomEffect(potion, PotionEffect.BLINDNESS, 1, 30 + rand.method_43048(60));
                PotionEffect.addCustomEffect(potion, PotionEffect.RESISTANCE, 2, 30 + rand.method_43048(30));
                Loot.setItemName(potion, "Moonshine");
                Loot.setItemLore(potion, TextFormat.getCode(TextFormat.OBFUSCATED).concat("bootleg"));
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(250, 240, 230));
                return potion;
            }
            case 2: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.POISON, 1, 10);
                PotionEffect.addCustomEffect(potion, PotionEffect.NIGHTVISION, 1, 120);
                PotionEffect.addCustomEffect(potion, PotionEffect.JUMP, 3, 120);
                Loot.setItemName(potion, "Wormwood");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(200, 250, 150));
                return potion;
            }
            case 3: {
                class_1799 potion = PotionItem.getSpecific(rand, PotionForm.values()[rand.method_43048(PotionForm.values().length)], PotionItem.values()[rand.method_43048(PotionItem.values().length)]);
                PotionMixture.addRandomEffects(rand, potion, 2 + rand.method_43048(2));
                Loot.setItemName(potion, "Vile Mixture");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                return potion;
            }
            case 5: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.STRENGTH, 3, 180);
                PotionEffect.addCustomEffect(potion, PotionEffect.BLINDNESS, 1, 30);
                PotionEffect.addCustomEffect(potion, PotionEffect.WITHER, 1, 10);
                Loot.setItemName(potion, "Animus");
                Loot.setItemLore(potion, "A swirling red storm");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(200, 0, 0));
                return potion;
            }
            case 7: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.SATURATION, 10, 1);
                PotionEffect.addCustomEffect(potion, PotionEffect.SPEED, 2, 120);
                PotionEffect.addCustomEffect(potion, PotionEffect.HASTE, 2, 120);
                PotionEffect.addCustomEffect(potion, PotionEffect.JUMP, 2, 120);
                Loot.setItemName(potion, "Vitae");
                Loot.setItemLore(potion, "Essence of life");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(230, 50, 20));
                return potion;
            }
            case 6: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.REGEN, 1, 5);
                PotionEffect.addCustomEffect(potion, PotionEffect.SATURATION, 2, 1);
                PotionEffect.addCustomEffect(potion, PotionEffect.HEALTHBOOST, 2, 120);
                PotionEffect.addCustomEffect(potion, PotionEffect.RESISTANCE, 1, 120);
                Loot.setItemName(potion, "Stout");
                Loot.setItemLore(potion, "\"It's Good for You\"");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(50, 40, 20));
                return potion;
            }
            case 8: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.ABSORPTION, 4, 180);
                PotionEffect.addCustomEffect(potion, PotionEffect.RESISTANCE, 3, 180);
                PotionEffect.addCustomEffect(potion, PotionEffect.HEALTH, 2, 1);
                Loot.setItemName(potion, "Nectar");
                Loot.setItemLore(potion, "A Floral extract.");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(250, 150, 250));
                return potion;
            }
            case 9: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.HASTE, 2, 600);
                PotionEffect.addCustomEffect(potion, PotionEffect.SPEED, 1, 600);
                Loot.setItemName(potion, "Coffee");
                Loot.setItemLore(potion, "A darkroast bean brew.");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(20, 20, 10));
                return potion;
            }
            case 10: {
                class_1799 potion = PotionItem.getSpecific(PotionForm.REGULAR, null, false, false);
                PotionEffect.addCustomEffect(potion, PotionEffect.GLOWING, 1, 600);
                Loot.setItemName(potion, "Luma");
                Loot.setItemLore(potion, "A glowstone extract.");
                Loot.setRarity(potion, class_1814.field_8907);
                ItemHideFlags.set(ItemHideFlags.EFFECTS, potion);
                PotionMixture.setColor(potion, Color.RGBToColor(250, 250, 0));
                return potion;
            }
        }
        return new class_1799((class_1935)class_1802.field_8469);
    }

    public static class_1799 getBooze(class_5819 rand) {
        PotionMixture[] booze = new PotionMixture[]{TEQUILA, LAUDANUM, MOONSHINE, ABSINTHE, STOUT};
        List<PotionMixture> potions = Arrays.asList(booze);
        int choice = rand.method_43048(potions.size());
        PotionMixture type = potions.get(choice);
        return PotionMixture.getPotion(rand, type);
    }

    public static class_1799 getRandom(class_5819 rand) {
        PotionMixture[] potions = new PotionMixture[]{LAUDANUM, ANIMUS, STAMINA, NECTAR, COFFEE, AURA};
        int choice = rand.method_43048(potions.length);
        PotionMixture type = potions[choice];
        return PotionMixture.getPotion(rand, type);
    }

    public static void addRandomEffects(class_5819 rand, class_1799 potion, int numEffects) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>(Arrays.asList(PotionEffect.values()));
        RandHelper.shuffle(effects, rand);
        for (int i = 0; i < numEffects; ++i) {
            PotionEffect type = (PotionEffect)((Object)effects.get(i));
            PotionEffect.addCustomEffect(potion, type, rand.method_43048(3), switch (type) {
                case PotionEffect.SATURATION, PotionEffect.HEALTH, PotionEffect.DAMAGE -> 1;
                case PotionEffect.REGEN -> 10 + rand.method_43048(20);
                case PotionEffect.HUNGER -> 5 + rand.method_43048(10);
                case PotionEffect.WITHER, PotionEffect.POISON -> 5 + rand.method_43048(5);
                default -> 10;
            });
        }
    }

    public static void setColor(class_1799 potion, int color) {
        class_1844 contents = (class_1844)potion.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        List effects = contents.comp_2380();
        class_1844 c = new class_1844(Optional.empty(), Optional.of(color), effects, contents.comp_3209());
        potion.method_57379(class_9334.field_49651, (Object)c);
    }
}

