/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.provider;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.loot.Enchant;
import com.greymerk.roguelike.treasure.loot.Equipment;
import com.greymerk.roguelike.treasure.loot.Loot;
import com.greymerk.roguelike.treasure.loot.Quality;
import com.greymerk.roguelike.treasure.loot.provider.ItemArmour;
import com.greymerk.roguelike.treasure.loot.provider.ItemBase;
import com.greymerk.roguelike.util.TextFormat;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class ItemSpecialty
extends ItemBase {
    private Equipment type;
    private Quality quality;
    private class_5455 reg;

    public ItemSpecialty(class_5455 reg, int weight, Difficulty diff) {
        super(weight, diff);
        this.reg = reg;
    }

    public ItemSpecialty(class_5455 reg, int weight, Difficulty diff, Equipment type, Quality q) {
        super(weight, diff);
        this.type = type;
        this.quality = q;
        this.reg = reg;
    }

    public ItemSpecialty(class_5455 reg, int weight, Difficulty diff, Quality q) {
        super(weight, diff);
        this.quality = q;
        this.reg = reg;
    }

    @Override
    public class_1799 get(class_5819 rand) {
        Equipment t = this.type == null ? Equipment.values()[rand.method_43048(Equipment.values().length)] : this.type;
        Quality q = this.quality == null ? Quality.get(rand, this.diff, t) : this.quality;
        return ItemSpecialty.getRandomItem(this.reg, t, rand, q);
    }

    public static class_1799 getRandomItem(class_5455 reg, class_5819 rand, Difficulty diff) {
        return ItemSpecialty.getRandomItem(reg, Equipment.values()[rand.method_43048(Equipment.values().length)], rand, diff);
    }

    public static class_1799 getRandomItem(class_5455 reg, Equipment type, class_5819 rand, Difficulty diff) {
        return ItemSpecialty.getRandomItem(reg, type, rand, Quality.get(rand, diff, type));
    }

    public static class_1799 getRandomItem(class_5455 reg, Equipment type, class_5819 rand, Quality quality) {
        class_1799 item = switch (type) {
            case Equipment.SWORD -> ItemSpecialty.getSword(reg, rand, quality);
            case Equipment.BOW -> ItemSpecialty.getBow(reg, rand, quality);
            case Equipment.HELMET -> ItemSpecialty.getHelmet(reg, rand, quality);
            case Equipment.CHEST -> ItemSpecialty.getChest(reg, rand, quality);
            case Equipment.LEGS -> ItemSpecialty.getLegs(reg, rand, quality);
            case Equipment.FEET -> ItemSpecialty.getBoots(reg, rand, quality);
            case Equipment.PICK -> ItemSpecialty.getPick(reg, rand, quality);
            case Equipment.AXE -> ItemSpecialty.getAxe(reg, rand, quality);
            case Equipment.SHOVEL -> ItemSpecialty.getShovel(reg, rand, quality);
            default -> ItemSpecialty.getSword(reg, rand, quality);
        };
        Loot.setRarity(item, class_1814.field_8903);
        return item;
    }

    public static class_1799 getRandomArmour(class_5455 reg, class_5819 rand, Quality quality) {
        switch (rand.method_43048(4)) {
            case 0: {
                return ItemSpecialty.getRandomItem(reg, Equipment.HELMET, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(reg, Equipment.CHEST, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(reg, Equipment.LEGS, rand, quality);
            }
            case 3: {
                return ItemSpecialty.getRandomItem(reg, Equipment.FEET, rand, quality);
            }
        }
        return ItemSpecialty.getRandomItem(reg, Equipment.HELMET, rand, quality);
    }

    public static class_1799 getRandomTool(class_5455 reg, class_5819 rand, Quality quality) {
        switch (rand.method_43048(3)) {
            case 0: {
                return ItemSpecialty.getRandomItem(reg, Equipment.PICK, rand, quality);
            }
            case 1: {
                return ItemSpecialty.getRandomItem(reg, Equipment.AXE, rand, quality);
            }
            case 2: {
                return ItemSpecialty.getRandomItem(reg, Equipment.SHOVEL, rand, quality);
            }
        }
        return ItemSpecialty.getRandomItem(reg, Equipment.PICK, rand, quality);
    }

    private static class_1799 getShovel(class_5455 reg, class_5819 rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            class_1799 item = new class_1799((class_1935)class_1802.field_8250);
            item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 3 + rand.method_43048(3));
            item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            Loot.setItemName(item, "Soul Spade");
            return item;
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8699);
        item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 1 + rand.method_43048(2));
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        Loot.setItemName(item, "Grave Spade");
        return item;
    }

    private static class_1799 getAxe(class_5455 reg, class_5819 rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            class_1799 item = new class_1799((class_1935)class_1802.field_8556);
            item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 3 + rand.method_43048(3));
            item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            Loot.setItemName(item, "Crystal Head Axe");
            return item;
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8475);
        item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 1 + rand.method_43048(2));
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        Loot.setItemName(item, "Woodland Hatchet");
        return item;
    }

    private static class_1799 getPick(class_5455 reg, class_5819 rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            class_1799 item = new class_1799((class_1935)class_1802.field_8377);
            item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 3 + rand.method_43048(3));
            item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
            if (rand.method_43048(10) == 0) {
                item.method_7978(Enchant.getEnchant(reg, Enchant.SILKTOUCH), 1);
                Loot.setItemName(item, "Crystal Pick of Precision");
                return item;
            }
            if (rand.method_43048(10) == 0) {
                item.method_7978(Enchant.getEnchant(reg, Enchant.FORTUNE), 2 + rand.method_43048(2));
                Loot.setItemName(item, "Crystal Pick of Prospecting");
                return item;
            }
            if (rand.method_43048(5) == 0) {
                item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
            }
            Loot.setItemName(item, "Crystal Pick");
            return item;
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8403);
        item.method_7978(Enchant.getEnchant(reg, Enchant.EFFICIENCY), 1 + rand.method_43048(2));
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.SILKTOUCH), 1);
            Loot.setItemName(item, "Case Hardened Pick of Precision");
            return item;
        }
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.FORTUNE), 1 + rand.method_43048(3));
            Loot.setItemName(item, "Case Hardened Pick of Prospecting");
            return item;
        }
        if (rand.method_43048(5) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        }
        Loot.setItemName(item, "Case Hardened Pick");
        return item;
    }

    private static class_1799 getSword(class_5455 reg, class_5819 rand, Quality quality) {
        if (quality == Quality.DIAMOND) {
            class_1799 item = new class_1799((class_1935)class_1802.field_8802);
            item.method_7978(Enchant.getEnchant(reg, Enchant.SHARPNESS), 3 + rand.method_43048(3));
            if (rand.method_43048(10) == 0) {
                item.method_7978(Enchant.getEnchant(reg, Enchant.LOOTING), 2 + rand.method_43048(2));
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                Loot.setItemName(item, "Eldritch Blade of Plundering");
                Loot.setItemLore(item, "The loot taker", TextFormat.DARKGREEN);
                return item;
            }
            if (rand.method_43048(10) == 0) {
                item.method_7978(Enchant.getEnchant(reg, Enchant.FIREASPECT), 2 + rand.method_43048(2));
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                Loot.setItemName(item, "Eldritch Blade of the Inferno");
                Loot.setItemLore(item, "From the fiery depths", TextFormat.DARKGREEN);
                return item;
            }
            item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), quality == Quality.DIAMOND ? 3 : 1 + rand.method_43048(2));
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
            Loot.setItemName(item, "Eldritch Blade");
            Loot.setItemLore(item, "Rune Etched", TextFormat.DARKGREEN);
            return item;
        }
        class_1799 item = new class_1799((class_1935)class_1802.field_8371);
        if (rand.method_43056()) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.SHARPNESS), 1);
        }
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), 3);
        item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        Loot.setItemName(item, "Tempered Blade");
        Loot.setItemLore(item, "Highly Durable", TextFormat.DARKGREEN);
        return item;
    }

    private static class_1799 getBow(class_5455 reg, class_5819 rand, Quality quality) {
        class_1799 item = new class_1799((class_1935)class_1802.field_8102);
        switch (quality) {
            case WOOD: 
            case STONE: {
                item.method_7978(Enchant.getEnchant(reg, Enchant.POWER), 1 + rand.method_43048(3));
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), 1);
                Loot.setItemName(item, "Yew Longbow");
                Loot.setItemLore(item, "Superior craftsmanship", TextFormat.DARKGREEN);
                return item;
            }
            case COPPER: 
            case IRON: {
                item.method_7978(Enchant.getEnchant(reg, Enchant.POWER), 1 + rand.method_43048(3));
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), 1 + rand.method_43048(3));
                Loot.setItemName(item, "Laminated Bow");
                Loot.setItemLore(item, "Highly polished", TextFormat.DARKGREEN);
                return item;
            }
            case GOLD: {
                item.method_7978(Enchant.getEnchant(reg, Enchant.POWER), 3 + rand.method_43048(3));
                if (rand.method_43056()) {
                    item.method_7978(Enchant.getEnchant(reg, Enchant.INFINITY), 1);
                }
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), 1 + rand.method_43048(3));
                Loot.setItemName(item, "Recurve Bow");
                Loot.setItemLore(item, "Beautifully crafted", TextFormat.DARKGREEN);
                return item;
            }
            case DIAMOND: {
                item.method_7978(Enchant.getEnchant(reg, Enchant.POWER), 3 + rand.method_43048(3));
                item.method_7978(Enchant.getEnchant(reg, Enchant.FLAME), 1);
                item.method_7978(Enchant.getEnchant(reg, Enchant.INFINITY), 1);
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
                Loot.setItemName(item, "Eldritch Bow");
                Loot.setItemLore(item, "Warm to the touch", TextFormat.DARKGREEN);
                return item;
            }
            case NETHERITE: {
                item.method_7978(Enchant.getEnchant(reg, Enchant.POWER), 3 + rand.method_43048(3));
                item.method_7978(Enchant.getEnchant(reg, Enchant.FLAME), 1);
                item.method_7978(Enchant.getEnchant(reg, Enchant.INFINITY), 1);
                item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
                item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
                Loot.setItemName(item, "Eldritch Bow");
                Loot.setItemLore(item, "Warm to the touch", TextFormat.DARKGREEN);
                return item;
            }
        }
        return item;
    }

    private static class_1799 getHelmet(class_5455 reg, class_5819 rand, Quality quality) {
        class_1799 item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new class_1799((class_1935)class_1802.field_8267);
                ItemArmour.dyeArmor(item, rand.method_43048(256), rand.method_43048(255), rand.method_43048(255));
                canonical = "Bonnet";
                break;
            }
            case STONE: {
                item = new class_1799((class_1935)class_1802.field_8283);
                canonical = "Coif";
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: {
                item = new class_1799((class_1935)class_1802.field_8743);
                canonical = "Sallet";
                break;
            }
            case DIAMOND: {
                item = new class_1799((class_1935)class_1802.field_8805);
                canonical = "Helm";
                break;
            }
            case NETHERITE: {
                item = new class_1799((class_1935)class_1802.field_22027);
                canonical = "Visor";
                break;
            }
            default: {
                item = new class_1799((class_1935)class_1802.field_8267);
            }
        }
        String suffix = "";
        if (rand.method_43048(20) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            item.method_7978(Enchant.getEnchant(reg, Enchant.RESPIRATION), 3);
            item.method_7978(Enchant.getEnchant(reg, Enchant.AQUAAFFINITY), 1);
            suffix = "of Diving";
        } else if (rand.method_43048(3) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static class_1799 getBoots(class_5455 reg, class_5819 rand, Quality quality) {
        class_1799 item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new class_1799((class_1935)class_1802.field_8370);
                ItemArmour.dyeArmor(item, rand.method_43048(256), rand.method_43048(255), rand.method_43048(255));
                canonical = "Shoes";
                break;
            }
            case STONE: {
                item = new class_1799((class_1935)class_1802.field_8313);
                canonical = "Greaves";
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: {
                item = new class_1799((class_1935)class_1802.field_8660);
                canonical = "Sabatons";
                break;
            }
            case DIAMOND: {
                item = new class_1799((class_1935)class_1802.field_8285);
                canonical = "Boots";
                break;
            }
            case NETHERITE: {
                item = new class_1799((class_1935)class_1802.field_22030);
                canonical = "Stompers";
                break;
            }
            default: {
                item = new class_1799((class_1935)class_1802.field_8370);
                canonical = "Shoes";
            }
        }
        String suffix = "";
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Warding";
        } else if (rand.method_43048(5) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            item.method_7978(Enchant.getEnchant(reg, Enchant.FEATHERFALLING), quality == Quality.DIAMOND ? 4 : 1 + rand.method_43048(3));
            suffix = "of Lightness";
        } else if (rand.method_43048(3) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static class_1799 getLegs(class_5455 reg, class_5819 rand, Quality quality) {
        class_1799 item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new class_1799((class_1935)class_1802.field_8570);
                ItemArmour.dyeArmor(item, rand.method_43048(256), rand.method_43048(255), rand.method_43048(255));
                canonical = "Pantaloons";
                break;
            }
            case STONE: {
                item = new class_1799((class_1935)class_1802.field_8218);
                canonical = "Chausses";
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: {
                item = new class_1799((class_1935)class_1802.field_8396);
                canonical = "Leg-plates";
                break;
            }
            case DIAMOND: {
                item = new class_1799((class_1935)class_1802.field_8348);
                canonical = "Leggings";
                break;
            }
            case NETHERITE: {
                item = new class_1799((class_1935)class_1802.field_22030);
                canonical = "Leg-guards";
                break;
            }
            default: {
                item = new class_1799((class_1935)class_1802.field_8570);
            }
        }
        String suffix = "";
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Warding";
        } else if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Integrity";
        } else if (rand.method_43048(3) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static class_1799 getChest(class_5455 reg, class_5819 rand, Quality quality) {
        class_1799 item;
        String canonical = "";
        switch (quality) {
            case WOOD: {
                item = new class_1799((class_1935)class_1802.field_8577);
                ItemArmour.dyeArmor(item, rand.method_43048(256), rand.method_43048(255), rand.method_43048(255));
                canonical = "Tunic";
                break;
            }
            case STONE: {
                item = new class_1799((class_1935)class_1802.field_8873);
                canonical = "Hauberk";
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: {
                item = new class_1799((class_1935)class_1802.field_8523);
                canonical = "Cuirass";
                break;
            }
            case DIAMOND: {
                item = new class_1799((class_1935)class_1802.field_8058);
                canonical = "Plate";
                break;
            }
            case NETHERITE: {
                item = new class_1799((class_1935)class_1802.field_22028);
                canonical = "Soul cage";
                break;
            }
            default: {
                item = new class_1799((class_1935)class_1802.field_8577);
                canonical = "Tunic";
            }
        }
        String suffix = "";
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.FIREPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Flamewarding";
        } else if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.BLASTPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Integrity";
        } else if (rand.method_43048(3) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROJECTILEPROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Deflection";
        } else {
            item.method_7978(Enchant.getEnchant(reg, Enchant.PROTECTION), ItemSpecialty.getProtectionLevel(quality, rand));
            suffix = "of Defense";
        }
        item.method_7978(Enchant.getEnchant(reg, Enchant.UNBREAKING), ItemSpecialty.getUnbreakingLevel(quality, rand));
        if (rand.method_43048(10) == 0) {
            item.method_7978(Enchant.getEnchant(reg, Enchant.MENDING), 1);
        }
        String name = ItemSpecialty.getArmourPrefix(quality) + " " + canonical + " " + suffix;
        Loot.setItemName(item, name);
        return item;
    }

    private static int getUnbreakingLevel(Quality quality, class_5819 rand) {
        return quality == Quality.DIAMOND ? 3 : 1 + rand.method_43048(2);
    }

    private static int getProtectionLevel(Quality quality, class_5819 rand) {
        int value = 1;
        switch (quality) {
            case WOOD: {
                if (rand.method_43048(3) != 0) break;
                ++value;
                break;
            }
            case STONE: {
                if (!rand.method_43056()) break;
                ++value;
                break;
            }
            case COPPER: 
            case IRON: 
            case GOLD: {
                value += rand.method_43048(3);
                break;
            }
            case DIAMOND: 
            case NETHERITE: {
                value += 2 + rand.method_43048(2);
            }
        }
        return value;
    }

    private static String getArmourPrefix(Quality quality) {
        switch (quality) {
            case WOOD: {
                return "Surplus";
            }
            case STONE: {
                return "Riveted";
            }
            case COPPER: {
                return "Tarnished";
            }
            case IRON: {
                return "Gothic";
            }
            case GOLD: {
                return "Jewelled";
            }
            case DIAMOND: {
                return "Crystal";
            }
            case NETHERITE: {
                return "Ornate";
            }
        }
        return "Strange";
    }

    @Override
    public class_1799 getLootItem(class_5819 rand, Difficulty diff) {
        return ItemSpecialty.getRandomItem(this.reg, Equipment.values()[rand.method_43048(Equipment.values().length)], rand, Quality.get(diff));
    }
}

