/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.provider;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.loot.Enchant;
import com.greymerk.roguelike.treasure.loot.Equipment;
import com.greymerk.roguelike.treasure.loot.Quality;
import com.greymerk.roguelike.treasure.loot.provider.ItemBase;
import com.greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import com.greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7699;

public class ItemWeapon
extends ItemBase {
    class_5455 reg;
    class_7699 features;

    public ItemWeapon(class_5455 reg, class_7699 features, int weight, Difficulty diff) {
        super(weight, diff);
        this.features = features;
        this.reg = reg;
    }

    @Override
    public class_1799 getLootItem(class_5819 rand, Difficulty diff) {
        if (rand.method_43048(1000) == 0) {
            return ItemNovelty.getItem(this.reg, ItemNovelty.GREYMERK);
        }
        return ItemWeapon.getRandom(this.reg, this.features, rand, diff, true);
    }

    public static class_1799 getRandom(class_5455 reg, class_7699 features, class_5819 rand, Difficulty diff, boolean enchant) {
        if (rand.method_43048(10) == 0) {
            return ItemWeapon.getBow(reg, features, rand, diff, enchant);
        }
        return ItemWeapon.getSword(reg, features, rand, diff, enchant);
    }

    public static class_1799 getBow(class_5455 reg, class_7699 features, class_5819 rand, Difficulty diff, boolean enchant) {
        if (enchant && rand.method_43048(1000) == 0) {
            return ItemNovelty.getItem(reg, ItemNovelty.WINDFORCE);
        }
        if (enchant && rand.method_43048(30) == 0) {
            return ItemSpecialty.getRandomItem(reg, Equipment.BOW, rand, diff);
        }
        class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
        if (enchant) {
            Enchant.enchantItem(reg, rand, bow, diff);
        }
        return bow;
    }

    public static class_1799 getSword(class_5455 reg, class_7699 features, class_5819 rand, Difficulty diff, boolean enchant) {
        if (enchant && rand.method_43048(1000) == 0) {
            return ItemNovelty.getItem(reg, ItemNovelty.NULL);
        }
        if (enchant && rand.method_43048(30) == 0) {
            return ItemSpecialty.getRandomItem(reg, Equipment.SWORD, rand, diff);
        }
        class_1799 sword = ItemWeapon.pickSword(rand, diff);
        if (enchant) {
            Enchant.enchantItem(reg, rand, sword, diff);
        }
        return sword;
    }

    public static class_1799 getSword(class_5455 reg, class_7699 features, class_5819 rand, Difficulty diff, boolean enchant, Quality quality) {
        class_1799 sword = quality != null ? ItemWeapon.getSwordByQuality(quality) : ItemWeapon.pickSword(rand, diff);
        return enchant ? Enchant.enchantItem(reg, rand, sword, diff) : sword;
    }

    private static class_1799 pickSword(class_5819 rand, Difficulty diff) {
        Quality quality = Quality.getWeaponQuality(rand, diff);
        return ItemWeapon.getSwordByQuality(quality);
    }

    private static class_1799 getSwordByQuality(Quality quality) {
        switch (quality) {
            case NETHERITE: {
                return new class_1799((class_1935)class_1802.field_22022);
            }
            case DIAMOND: {
                return new class_1799((class_1935)class_1802.field_8802);
            }
            case GOLD: {
                return new class_1799((class_1935)class_1802.field_8845);
            }
            case IRON: {
                return new class_1799((class_1935)class_1802.field_8371);
            }
            case COPPER: {
                return new class_1799((class_1935)class_1802.field_61338);
            }
            case STONE: {
                return new class_1799((class_1935)class_1802.field_8528);
            }
        }
        return new class_1799((class_1935)class_1802.field_8091);
    }
}

