/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.loot.rules;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.TreasureManager;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.util.IWeighted;
import net.minecraft.class_1799;
import net.minecraft.class_5819;

public class LootRule {
    private Treasure type;
    private IWeighted<class_1799> item;
    Difficulty diff;
    int amount;

    public LootRule(Treasure type, IWeighted<class_1799> item, Difficulty diff, int amount) {
        this.type = type;
        this.item = item;
        this.diff = diff;
        this.amount = amount;
    }

    public void process(class_5819 rand, TreasureManager treasure) {
        treasure.addItemToAll(rand, this.type, this.diff, this.item, this.amount);
    }

    public void process(class_5819 rand, ITreasureChest chest) {
        if (chest.getLevel() != this.diff) {
            return;
        }
        if (this.type == Treasure.ALL) {
            this.addItems(rand, chest);
        }
        if (this.type == chest.getType()) {
            this.addItems(rand, chest);
        }
    }

    public void addItems(class_5819 rand, ITreasureChest chest) {
        for (int i = 0; i < this.amount; ++i) {
            chest.setRandomEmptySlot(this.item.get(rand));
        }
    }

    public String toString() {
        String type = this.type.toString();
        int amount = this.amount;
        return "type: " + type + " diff: " + String.valueOf((Object)this.diff) + " amount: " + amount;
    }
}

