/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.util;

import com.greymerk.roguelike.util.IWeighted;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5819;

public class WeightedRandomizer<T>
implements IWeighted<T> {
    private int weight;
    private int weightSum;
    private List<IWeighted<T>> items;

    public WeightedRandomizer(int weight) {
        assert (weight > 0);
        this.weight = weight;
        this.weightSum = 0;
        this.items = new ArrayList<IWeighted<T>>();
    }

    public WeightedRandomizer() {
        this(1);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public WeightedRandomizer<T> add(IWeighted<T> toAdd) {
        this.weightSum += toAdd.getWeight();
        this.items.add(toAdd);
        return this;
    }

    @Override
    public T get(class_5819 rand) {
        if (this.weightSum == 0) {
            return null;
        }
        if (this.items.isEmpty()) {
            return null;
        }
        int roll = rand.method_43048(this.weightSum);
        for (IWeighted<T> i : this.items) {
            if ((roll -= i.getWeight()) >= 0) continue;
            return i.get(rand);
        }
        return null;
    }

    public void merge(WeightedRandomizer<T> toMerge) {
        for (IWeighted<T> item : toMerge.items) {
            this.add(item);
        }
    }
}

