/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat;

import de.crafty.eiv.servercompat.api.IEivCompatIntegration;
import de.crafty.eiv.servercompat.builtin.BuiltinEivCompatIntegration;
import de.crafty.eiv.servercompat.event.PlayerJoinListener;
import de.crafty.eiv.servercompat.log.Data;
import de.crafty.eiv.servercompat.recipe.CompatRecipeManager;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EivPlugin
extends JavaPlugin {
    public static final String PLUGIN_ID = "eiv";
    public static final String MESSAGE_CHANNEL = "eiv:compat";
    private static EivPlugin instance;

    public void onEnable() {
        instance = this;
        Data.log("Loading Extended ItemView...");
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, MESSAGE_CHANNEL);
        CompatRecipeManager.INSTANCE.registerIntegration((Plugin)this, new BuiltinEivCompatIntegration());
        this.discoverIntegrations();
        CompatRecipeManager.INSTANCE.loadIntegrations();
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        Data.log("Extended ItemView has been enabled.");
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, MESSAGE_CHANNEL);
        Data.log("Extended ItemView has been disabled.");
    }

    public static EivPlugin getInstance() {
        return instance;
    }

    private void discoverIntegrations() {
        Data.log("Integration discovery started...");
        HashMap<Plugin, Class> integrationClasses = new HashMap<Plugin, Class>();
        for (Plugin plugin2 : Bukkit.getPluginManager().getPlugins()) {
            YamlConfiguration config;
            if (!plugin2.isEnabled() || plugin2.getResource("plugin.yml") == null || !(config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin2.getResource("plugin.yml")))).contains("eiv-compat")) continue;
            try {
                integrationClasses.put(plugin2, Class.forName(config.getString("eiv-compat")));
            }
            catch (ClassCastException | ClassNotFoundException e) {
                Data.error("Invalid eiv-compat class in plugin.yml, skipping plugin...");
            }
        }
        integrationClasses.forEach((plugin, integrationClass) -> {
            try {
                CompatRecipeManager.INSTANCE.registerIntegration((Plugin)plugin, (IEivCompatIntegration)integrationClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                Data.error("Invalid eiv-compat class in plugin.yml, skipping plugin...");
            }
        });
        Data.log(String.format("Found %s EIV-Compat integration(s).", CompatRecipeManager.INSTANCE.getIntegrationCount()));
    }
}

