/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat.api;

import de.crafty.eiv.servercompat.api.recipe.IEivCompatServerRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompatItemView {
    private static final List<CompatRecipeProvider> RECIPE_PROVIDERS = new ArrayList<CompatRecipeProvider>();
    private static final HashMap<Item, List<StackSensitive>> STACK_SENSITIVE = new HashMap();
    private static final List<ReloadCallback> RELOAD_CALLBACKS = new ArrayList<ReloadCallback>();

    public static void addRecipeProvider(CompatRecipeProvider recipeProvider) {
        RECIPE_PROVIDERS.add(recipeProvider);
    }

    public static List<CompatRecipeProvider> getRecipeProviders() {
        return RECIPE_PROVIDERS;
    }

    public static void clearProviders() {
        RECIPE_PROVIDERS.clear();
    }

    public static void addStackSensitive(ItemStack stack) {
        List present = STACK_SENSITIVE.getOrDefault(stack.getItem(), new ArrayList());
        present.add(new StackSensitive(stack));
        STACK_SENSITIVE.put(stack.getItem(), present);
    }

    public static HashMap<Item, List<StackSensitive>> getStackSensitive() {
        return STACK_SENSITIVE;
    }

    public static void addReloadCallback(ReloadCallback callback) {
        RELOAD_CALLBACKS.add(callback);
    }

    public static List<ReloadCallback> getReloadCallbacks() {
        return RELOAD_CALLBACKS;
    }

    public record StackSensitive(ItemStack stack) {
        private final ItemStack stack;

        public ItemStack stack() {
            return this.stack.copy();
        }
    }

    public static interface CompatRecipeProvider {
        public void provide(List<IEivCompatServerRecipe> var1);
    }

    public static interface ReloadCallback {
        public void onReload();
    }
}

