/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat.builtin;

import de.crafty.eiv.servercompat.api.CompatItemView;
import de.crafty.eiv.servercompat.api.IEivCompatIntegration;
import de.crafty.eiv.servercompat.builtin.blasting.CompatBlastingRecipe;
import de.crafty.eiv.servercompat.builtin.brewing.CompatBrewingRecipe;
import de.crafty.eiv.servercompat.builtin.burning.CompatBurningRecipe;
import de.crafty.eiv.servercompat.builtin.campfire.CompatCampfireRecipe;
import de.crafty.eiv.servercompat.builtin.shaped.CompatShapedRecipe;
import de.crafty.eiv.servercompat.builtin.shapeless.CompatShapelessRecipe;
import de.crafty.eiv.servercompat.builtin.smelting.CompatSmeltingRecipe;
import de.crafty.eiv.servercompat.builtin.smithing.CompatSmithingRecipe;
import de.crafty.eiv.servercompat.builtin.smoking.CompatSmokingRecipe;
import de.crafty.eiv.servercompat.builtin.stonecutting.CompatStonecutterRecipe;
import de.crafty.eiv.servercompat.recipe.CompatRecipeManager;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.FuelValues;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.craftbukkit.inventory.trim.CraftTrimPattern;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class BuiltinEivCompatIntegration
implements IEivCompatIntegration {
    @Override
    public void onInitialize() {
        CompatItemView.addReloadCallback(() -> {
            Registry potionRegistry = CompatRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.POTION);
            potionRegistry.forEach(potion -> {
                CompatItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                CompatItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                CompatItemView.addStackSensitive(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionRegistry.wrapAsHolder(potion)));
                if (CompatRecipeManager.INSTANCE.getServer().potionBrewing().isBrewablePotion(potionRegistry.wrapAsHolder(potion))) {
                    net.minecraft.world.item.ItemStack tipped = new net.minecraft.world.item.ItemStack((ItemLike)Items.TIPPED_ARROW);
                    tipped.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potionRegistry.wrapAsHolder(potion)));
                    CompatItemView.addStackSensitive(tipped);
                }
            });
            Registry enchantmentRegistry = ((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            enchantmentRegistry.forEach(enchantment -> {
                for (int i = enchantment.getMinLevel(); i <= enchantment.getMaxLevel(); ++i) {
                    net.minecraft.world.item.ItemStack enchantedBook = EnchantmentHelper.createBook((EnchantmentInstance)new EnchantmentInstance(enchantmentRegistry.wrapAsHolder(enchantment), i));
                    CompatItemView.addStackSensitive(enchantedBook);
                }
            });
        });
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                HashMap<Integer, RecipeChoice> choices = new HashMap<Integer, RecipeChoice>();
                int height = shapedRecipe.getShape().length;
                int width = shapedRecipe.getShape()[0].length();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        char c = shapedRecipe.getShape()[y].charAt(x);
                        if (c == ' ') continue;
                        choices.put(x + y * 3, (RecipeChoice)shapedRecipe.getChoiceMap().get(Character.valueOf(c)));
                    }
                }
                recipeList.add(new CompatShapedRecipe(width, height, choices, CraftItemStack.asNMSCopy((ItemStack)shapedRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                recipeList.add(new CompatShapelessRecipe(shapelessRecipe.getChoiceList(), CraftItemStack.asNMSCopy((ItemStack)shapelessRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof FurnaceRecipe) {
                FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
                recipeList.add(new CompatSmeltingRecipe(furnaceRecipe.getInputChoice(), CraftItemStack.asNMSCopy((ItemStack)furnaceRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof BlastingRecipe) {
                BlastingRecipe blastingRecipe = (BlastingRecipe)recipe;
                recipeList.add(new CompatBlastingRecipe(blastingRecipe.getInputChoice(), CraftItemStack.asNMSCopy((ItemStack)blastingRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof SmokingRecipe) {
                SmokingRecipe smokingRecipe = (SmokingRecipe)recipe;
                recipeList.add(new CompatSmokingRecipe(smokingRecipe.getInputChoice(), CraftItemStack.asNMSCopy((ItemStack)smokingRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof StonecuttingRecipe) {
                StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
                recipeList.add(new CompatStonecutterRecipe(stonecuttingRecipe.getInputChoice(), CraftItemStack.asNMSCopy((ItemStack)stonecuttingRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> {
            PotionBrewing potionBrewing = CompatRecipeManager.INSTANCE.getServer().potionBrewing();
            Registry potionRegistry = CompatRecipeManager.INSTANCE.getServer().registryAccess().lookupOrThrow(Registries.POTION);
            potionRegistry.forEach(potion -> {
                net.minecraft.world.item.ItemStack potionStack = PotionContents.createItemStack((Item)Items.POTION, (Holder)potionRegistry.wrapAsHolder(potion));
                net.minecraft.world.item.ItemStack splashStack = PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potionRegistry.wrapAsHolder(potion));
                net.minecraft.world.item.ItemStack lingeringStack = PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potionRegistry.wrapAsHolder(potion));
                BuiltInRegistries.ITEM.forEach(item -> {
                    if (potionBrewing.hasMix(potionStack, new net.minecraft.world.item.ItemStack((ItemLike)item))) {
                        recipeList.add(new CompatBrewingRecipe(potionBrewing.mix(new net.minecraft.world.item.ItemStack((ItemLike)item), potionStack), CraftRecipe.toBukkit((Ingredient)Ingredient.of((ItemLike)item)), potionStack));
                    }
                    if (potionBrewing.hasMix(splashStack, new net.minecraft.world.item.ItemStack((ItemLike)item))) {
                        recipeList.add(new CompatBrewingRecipe(potionBrewing.mix(new net.minecraft.world.item.ItemStack((ItemLike)item), splashStack), CraftRecipe.toBukkit((Ingredient)Ingredient.of((ItemLike)item)), splashStack));
                    }
                    if (potionBrewing.hasMix(lingeringStack, new net.minecraft.world.item.ItemStack((ItemLike)item))) {
                        recipeList.add(new CompatBrewingRecipe(potionBrewing.mix(new net.minecraft.world.item.ItemStack((ItemLike)item), lingeringStack), CraftRecipe.toBukkit((Ingredient)Ingredient.of((ItemLike)item)), lingeringStack));
                    }
                });
            });
        });
        CompatItemView.addRecipeProvider(recipeList -> {
            FuelValues fuelValues = CompatRecipeManager.INSTANCE.getServer().fuelValues();
            fuelValues.fuelItems().forEach(item -> recipeList.add(new CompatBurningRecipe((Item)item, fuelValues.burnDuration(new net.minecraft.world.item.ItemStack((ItemLike)item)))));
        });
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof CampfireRecipe) {
                CampfireRecipe campfireRecipe = (CampfireRecipe)recipe;
                recipeList.add(new CompatCampfireRecipe(campfireRecipe.getInputChoice(), CraftItemStack.asNMSCopy((ItemStack)campfireRecipe.getResult())));
            }
        }));
        CompatItemView.addRecipeProvider(recipeList -> Bukkit.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
                recipeList.add(new CompatSmithingRecipe(true, trimRecipe.getBase(), trimRecipe.getTemplate(), trimRecipe.getAddition(), CraftTrimPattern.bukkitToMinecraft((TrimPattern)trimRecipe.getTrimPattern()), null));
            }
            if (recipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
                recipeList.add(new CompatSmithingRecipe(false, transformRecipe.getBase(), transformRecipe.getTemplate(), transformRecipe.getAddition(), null, new TransmuteResult(CraftItemStack.asNMSCopy((ItemStack)transformRecipe.getResult()).getItem())));
            }
        }));
    }
}

