/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat.builtin.smithing;

import com.mojang.serialization.DynamicOps;
import de.crafty.eiv.servercompat.api.recipe.EivCompatRecipeType;
import de.crafty.eiv.servercompat.api.recipe.IEivCompatServerRecipe;
import de.crafty.eiv.servercompat.util.EivCompatTagUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.Nullable;

public class CompatSmithingRecipe
implements IEivCompatServerRecipe {
    public static final EivCompatRecipeType<CompatSmithingRecipe> TYPE = EivCompatRecipeType.register(ResourceLocation.withDefaultNamespace((String)"smithing"));
    private boolean isTrim;
    private RecipeChoice base;
    private RecipeChoice template;
    private RecipeChoice addition;
    private TrimPattern pattern;
    private TransmuteResult upgradeResult;

    public CompatSmithingRecipe(boolean isTrim, RecipeChoice base, RecipeChoice template, RecipeChoice addition, TrimPattern pattern, @Nullable TransmuteResult upgradeResult) {
        this.isTrim = isTrim;
        this.base = base;
        this.template = template;
        this.addition = addition;
        this.pattern = pattern;
        this.upgradeResult = upgradeResult;
    }

    @Override
    public void writeToTag(CompoundTag tag) {
        tag.putBoolean("isTrim", this.isTrim);
        tag.put("base", (Tag)EivCompatTagUtil.writeChoice(this.base));
        tag.put("template", (Tag)EivCompatTagUtil.writeChoice(this.template));
        tag.put("addition", (Tag)EivCompatTagUtil.writeChoice(this.addition));
        if (this.pattern != null) {
            tag.put("pattern", (Tag)TrimPattern.DIRECT_CODEC.encode((Object)this.pattern, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
        if (this.upgradeResult != null) {
            tag.put("upgradeResult", (Tag)TransmuteResult.CODEC.encode((Object)this.upgradeResult, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
    }

    @Override
    public EivCompatRecipeType<? extends IEivCompatServerRecipe> getRecipeType() {
        return TYPE;
    }
}

