/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat.recipe;

import de.crafty.eiv.servercompat.api.CompatItemView;
import de.crafty.eiv.servercompat.api.IEivCompatIntegration;
import de.crafty.eiv.servercompat.api.recipe.EivCompatRecipeType;
import de.crafty.eiv.servercompat.api.recipe.IEivCompatServerRecipe;
import de.crafty.eiv.servercompat.log.Data;
import de.crafty.eiv.servercompat.network.CompatNetworking;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundCacheStartPayload;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundFinishUpdatesPayload;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundStartUpdatesPayload;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundTypeUpdateEndPayload;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundTypeUpdatePayload;
import de.crafty.eiv.servercompat.network.payload.recipe.ClientboundTypeUpdateStartPayload;
import de.crafty.eiv.servercompat.network.payload.stack.ClientboundFinishStackSensitivesPayload;
import de.crafty.eiv.servercompat.network.payload.stack.ClientboundStackSensitivePayload;
import de.crafty.eiv.servercompat.network.payload.stack.ClientboundStartStackSensitivesPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CompatRecipeManager {
    public static final CompatRecipeManager INSTANCE = new CompatRecipeManager();
    private final HashMap<Plugin, IEivCompatIntegration> PRESENT_INTEGRATIONS = new HashMap();
    private static final HashMap<EivCompatRecipeType<?>, List<CompatRecipeEntry>> PRESENT_RECIPES = new LinkedHashMap();

    public DedicatedServer getServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public void registerIntegration(Plugin plugin, IEivCompatIntegration integration) {
        this.PRESENT_INTEGRATIONS.put(plugin, integration);
    }

    public int getIntegrationCount() {
        return this.PRESENT_INTEGRATIONS.size();
    }

    public void loadIntegrations() {
        Data.log(String.format("Loading %s EIV-Compat integration(s)...", this.PRESENT_INTEGRATIONS.size()));
        this.PRESENT_INTEGRATIONS.forEach((plugin, integration) -> Data.log(String.format(" - %s", plugin.getName())));
        CompatItemView.clearProviders();
        this.PRESENT_INTEGRATIONS.values().forEach(IEivCompatIntegration::onInitialize);
        Data.log("All integrations have been loaded.");
        this.reload();
    }

    public void reload() {
        CompatItemView.getStackSensitive().clear();
        CompatItemView.getReloadCallbacks().forEach(CompatItemView.ReloadCallback::onReload);
        this.broadcastStackSensitives();
        this.reloadRecipes();
        this.broadcastRecipes();
    }

    private void broadcastStackSensitives() {
        if (CompatItemView.getStackSensitive().isEmpty()) {
            return;
        }
        Data.log("Informing " + Bukkit.getServer().getOnlinePlayers().size() + " players about " + CompatItemView.getStackSensitive().size() + " stack sensitives");
        Bukkit.getServer().getOnlinePlayers().forEach(this::updateStackSensitives);
    }

    public void updateStackSensitives(Player player) {
        ArrayList collected = new ArrayList();
        CompatItemView.getStackSensitive().forEach((item, stackSensitives) -> collected.addAll(stackSensitives));
        CompatNetworking.INSTANCE.sendPayload(player, new ClientboundStartStackSensitivesPayload(collected.size()));
        collected.forEach(stackSensitive -> CompatNetworking.INSTANCE.sendPayload(player, new ClientboundStackSensitivePayload((CompatItemView.StackSensitive)stackSensitive)));
        CompatNetworking.INSTANCE.sendPayload(player, new ClientboundFinishStackSensitivesPayload());
    }

    private void broadcastRecipes() {
        if (PRESENT_RECIPES.isEmpty()) {
            return;
        }
        Bukkit.getServer().getOnlinePlayers().forEach(this::updateRecipes);
    }

    public void updateRecipes(Player player) {
        Data.log("Informing " + player.getName() + " about " + PRESENT_RECIPES.size() + " recipe types");
        CompatNetworking.INSTANCE.sendPayload(player, new ClientboundStartUpdatesPayload());
        CompatNetworking.INSTANCE.sendPayload(player, new ClientboundCacheStartPayload(PRESENT_RECIPES.size()));
        PRESENT_RECIPES.forEach((type, entries) -> {
            CompatNetworking.INSTANCE.sendPayload(player, new ClientboundTypeUpdateStartPayload((EivCompatRecipeType<?>)type, entries.size()));
            entries.forEach(recipe -> CompatNetworking.INSTANCE.sendPayload(player, new ClientboundTypeUpdatePayload((CompatRecipeEntry)recipe)));
            CompatNetworking.INSTANCE.sendPayload(player, new ClientboundTypeUpdateEndPayload((EivCompatRecipeType<?>)type));
        });
        CompatNetworking.INSTANCE.sendPayload(player, new ClientboundFinishUpdatesPayload());
    }

    private void reloadRecipes() {
        PRESENT_RECIPES.clear();
        ArrayList serverRecipes = new ArrayList();
        CompatItemView.getRecipeProviders().forEach(serverModRecipeProvider -> {
            ArrayList<IEivCompatServerRecipe> recipes = new ArrayList<IEivCompatServerRecipe>();
            serverModRecipeProvider.provide(recipes);
            serverRecipes.addAll(recipes);
        });
        serverRecipes.forEach(iEivServerModRecipe -> {
            ResourceLocation typeId = iEivServerModRecipe.getRecipeType().getId();
            List list = PRESENT_RECIPES.getOrDefault(iEivServerModRecipe.getRecipeType(), new ArrayList());
            list.add(new CompatRecipeEntry(ResourceLocation.fromNamespaceAndPath((String)typeId.getNamespace(), (String)(typeId.getPath() + "/" + String.valueOf(UUID.randomUUID()))), (IEivCompatServerRecipe)iEivServerModRecipe));
            PRESENT_RECIPES.put(iEivServerModRecipe.getRecipeType(), list);
        });
    }

    public record CompatRecipeEntry(ResourceLocation modRecipeId, IEivCompatServerRecipe compatRecipe) {
        public CompoundTag createFullTagWithId() {
            CompoundTag fullTag = new CompoundTag();
            fullTag.putString("recipeId", this.modRecipeId().toString());
            CompoundTag recipeTag = new CompoundTag();
            recipeTag.putString("recipeType", this.compatRecipe().getRecipeType().getId().toString());
            CompoundTag dataTag = new CompoundTag();
            this.compatRecipe().writeToTag(dataTag);
            recipeTag.put("recipeData", (Tag)dataTag);
            fullTag.put("recipe", (Tag)recipeTag);
            return fullTag;
        }
    }
}

